/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler;

import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.ChemicalStackType;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;

public class ChemicalStackTypedHandler
implements IChemicalHandler {
    private StackTypedHandler handlerStorage;

    public ChemicalStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getChemicalTanks() {
        List<Integer> slots = this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID);
        if (slots != null) {
            return slots.size();
        }
        return 0;
    }

    public ChemicalStack getChemicalInTank(int tank) {
        List<Integer> slots = this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID);
        int actualIndex = -1;
        if (slots != null && 0 <= tank && tank < slots.size()) {
            actualIndex = slots.get(tank);
        }
        if (actualIndex != -1) {
            return (ChemicalStack)this.handlerStorage.getStackBySlot(actualIndex).getStack();
        }
        return ChemicalStack.EMPTY;
    }

    public void setChemicalInTank(int tank, ChemicalStack stack) {
        int actualIndex = -1;
        actualIndex = this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).get(tank);
        if (actualIndex >= 0) {
            this.handlerStorage.setStackDirectly(actualIndex, new ChemicalStackType(stack.copy()));
        }
    }

    public long getChemicalTankCapacity(int tank) {
        return 64000L;
    }

    public boolean isValid(int tank, ChemicalStack stack) {
        return true;
    }

    public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).get(tank), new ChemicalStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return stack.copyWithAmount(remaining);
        }
        return ChemicalStack.EMPTY;
    }

    public ChemicalStack extractChemical(int tank, long amount, Action action) {
        return ((ChemicalStackType)this.handlerStorage.extract(this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).get(tank), amount, action.simulate())).copyStack();
    }

    public ChemicalStack insertChemical(ChemicalStack stack, Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new ChemicalStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return stack.copyWithAmount(remaining);
        }
        return ChemicalStack.EMPTY;
    }

    public ChemicalStack extractChemical(long amount, Action action) {
        int actualIndex = this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).getFirst();
        return ((ChemicalStackType)this.handlerStorage.extract(this.handlerStorage.getStackBySlot(actualIndex).copy(), action.simulate())).copyStack();
    }

    public ChemicalStack extractChemical(ChemicalStack stack, Action action) {
        return ((ChemicalStackType)this.handlerStorage.extract(new ChemicalStackType(stack.copy()), action.simulate())).copyStack();
    }
}

