/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler;

import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import java.util.List;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidStackTypedHandler
implements IFluidHandler {
    private StackTypedHandler handlerStorage;

    public FluidStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        List<Integer> slots = this.handlerStorage.getTypeIdIndexList(FluidStackType.ID);
        if (slots != null) {
            return slots.size();
        }
        return 0;
    }

    public FluidStack getFluidInTank(int tank) {
        List<Integer> slots = this.handlerStorage.getTypeIdIndexList(FluidStackType.ID);
        int actualIndex = -1;
        if (slots != null && 0 <= tank && tank < slots.size()) {
            actualIndex = slots.get(tank);
        }
        if (actualIndex != -1) {
            return (FluidStack)this.handlerStorage.getStackBySlot(actualIndex).getStack();
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 64000;
    }

    public boolean isFluidValid(int tank, FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        int allAmount = fluidStack.getAmount();
        int remaining = (int)this.handlerStorage.insert(new FluidStackType(fluidStack.copy()), fluidAction.simulate()).getStackAmount();
        return allAmount - remaining;
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return ((FluidStackType)this.handlerStorage.extract(new FluidStackType(fluidStack.copy()), fluidAction.simulate())).copyStack();
    }

    public FluidStack drain(int count, IFluidHandler.FluidAction fluidAction) {
        int actualIndex = this.handlerStorage.getTypeIdIndexList(FluidStackType.ID).getFirst();
        return ((FluidStackType)this.handlerStorage.extract(this.handlerStorage.getStackBySlot(actualIndex).copy(), fluidAction.simulate())).copyStack();
    }
}

