/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.Stack.ChemicalStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;

public class ChemicalUnifiedStorageHandler
implements IChemicalHandler {
    private UnifiedStorage storage;

    public ChemicalUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getChemicalTanks() {
        List<Integer> slots = this.storage.getTypeIdIndexList(ChemicalStackType.ID);
        if (slots != null) {
            return slots.size();
        }
        return 0;
    }

    public ChemicalStack getChemicalInTank(int slot) {
        List<Integer> slots = this.storage.getTypeIdIndexList(ChemicalStackType.ID);
        int actualIndex = -1;
        if (slots != null && 0 <= slot && slot < slots.size()) {
            actualIndex = slots.get(slot);
        }
        if (actualIndex != -1) {
            return (ChemicalStack)this.storage.getStackBySlot(actualIndex).getStack();
        }
        return ChemicalStack.EMPTY;
    }

    public void setChemicalInTank(int tank, ChemicalStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        this.storage.insert(new ChemicalStackType(stack.copy()), false);
    }

    public long getChemicalTankCapacity(int tank) {
        return Long.MAX_VALUE;
    }

    public boolean isValid(int tank, ChemicalStack stack) {
        return true;
    }

    public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long remaining = this.storage.insert(new ChemicalStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return stack.copyWithAmount(remaining);
        }
        return ChemicalStack.EMPTY;
    }

    public ChemicalStack extractChemical(int tank, long amount, Action action) {
        return ((ChemicalStackType)this.storage.extract(new ChemicalStackType(this.getChemicalInTank(tank).copyWithAmount(amount)), action.simulate())).copyStack();
    }

    public ChemicalStack insertChemical(ChemicalStack stack, Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long remaining = this.storage.insert(new ChemicalStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return stack.copyWithAmount(remaining);
        }
        return ChemicalStack.EMPTY;
    }

    public ChemicalStack extractChemical(long amount, Action action) {
        return ((ChemicalStackType)this.storage.extract(new ChemicalStackType(this.getChemicalInTank(0).copyWithAmount(amount)), action.simulate())).copyStack();
    }

    public ChemicalStack extractChemical(ChemicalStack stack, Action action) {
        return ((ChemicalStackType)this.storage.extract(new ChemicalStackType(stack.copy()), action.simulate())).copyStack();
    }
}

