/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import java.util.List;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidUnifiedStorageHandler
implements IFluidHandler {
    private UnifiedStorage storage;

    public FluidUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getTanks() {
        List<Integer> slots = this.storage.getTypeIdIndexList(FluidStackType.ID);
        if (slots != null) {
            return slots.size();
        }
        return 0;
    }

    public FluidStack getFluidInTank(int slot) {
        List<Integer> slots = this.storage.getTypeIdIndexList(FluidStackType.ID);
        int actualIndex = -1;
        if (slots != null && 0 <= slot && slot < slots.size()) {
            actualIndex = slots.get(slot);
        }
        if (actualIndex != -1) {
            return (FluidStack)this.storage.getStackBySlot(actualIndex).getStack();
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int i) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int slot, FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        int allAmount = fluidStack.getAmount();
        int remaining = (int)this.storage.insert(new FluidStackType(fluidStack.copy()), fluidAction.simulate()).getStackAmount();
        return allAmount - remaining;
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return ((FluidStackType)this.storage.extract(new FluidStackType(fluidStack.copy()), fluidAction.simulate())).copyStack();
    }

    public FluidStack drain(int count, IFluidHandler.FluidAction fluidAction) {
        return ((FluidStackType)this.storage.extract(new FluidStackType(this.getFluidInTank(0).copyWithAmount(count)), fluidAction.simulate())).copyStack();
    }
}

