/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemUnifiedStorageHandler
implements IItemHandler {
    private UnifiedStorage storage;

    public ItemUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getSlots() {
        List<Integer> slots = this.storage.getTypeIdIndexList(ItemStackType.ID);
        if (slots != null) {
            return slots.size();
        }
        return 0;
    }

    public ItemStack getStackInSlot(int slot) {
        List<Integer> slots = this.storage.getTypeIdIndexList(ItemStackType.ID);
        int actualIndex = -1;
        if (slots != null && 0 <= slot && slot < slots.size()) {
            actualIndex = slots.get(slot);
        }
        if (actualIndex != -1) {
            return (ItemStack)this.storage.getStackBySlot(actualIndex).getStack();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack insertItem(int slot, ItemStack itemStack, boolean sim) {
        ItemStackType typedStack = (ItemStackType)this.storage.insert(new ItemStackType(itemStack), sim);
        return typedStack.getStack();
    }

    public ItemStack extractItem(int slot, int count, boolean sim) {
        return (ItemStack)this.storage.extract(new ItemStackType(this.getStackInSlot(slot).copyWithCount(count)), sim).getStack();
    }

    public int getSlotLimit(int slot) {
        return 0x7FFFFFFE;
    }

    public boolean isItemValid(int slot, ItemStack itemStack) {
        return true;
    }
}

