/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.ReverseButton;
import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import com.wintercogs.beyonddimensions.Packet.CallSeverStoragePacket;
import com.wintercogs.beyonddimensions.Packet.PopModeButtonPacket;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetEnergyGUI
extends AbstractContainerScreen<NetEnergyMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.parse((String)"beyonddimensions:textures/gui/net_energy_storage.png");
    public ReverseButton popButton;

    public NetEnergyGUI(NetEnergyMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 175;
    }

    protected void init() {
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - 235) / 2;
        this.font = Minecraft.getInstance().font;
        this.popButton = new ReverseButton(this.leftPos + 72 + 72 - 5, this.topPos + 6, button -> {
            this.popButton.toggleState();
            ((NetEnergyMenu)this.menu).popMode = !((NetEnergyMenu)this.menu).popMode;
            PacketDistributor.sendToServer((CustomPacketPayload)new PopModeButtonPacket(((NetEnergyMenu)this.menu).popMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        this.addRenderableWidget((GuiEventListener)this.popButton);
        ((NetEnergyMenu)this.menu).suppressRemoteUpdates();
        PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverStoragePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void containerTick() {
        if (((NetEnergyMenu)this.menu).popMode) {
            this.popButton.setState(ButtonState.DISABLED);
        } else {
            this.popButton.setState(ButtonState.ENABLED);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.popButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderEnergyBar(guiGraphics, this.leftPos + 8, this.topPos + 35);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY + 10, 0x404040, false);
        guiGraphics.drawString(this.font, StringFormat.formatCount(((NetEnergyMenu)this.menu).energyStored) + "/" + StringFormat.formatCount(((NetEnergyMenu)this.menu).energyCapacity), this.inventoryLabelX, this.inventoryLabelY - 20, 0x404040, false);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        super.renderSlot(guiGraphics, slot);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
    }

    protected void renderEnergyBar(GuiGraphics guiGraphics, int xStart, int yStart) {
        int areaWidth = 160;
        int areaHeight = 16;
        boolean stripeWidth = true;
        float[] brightnessFactors = new float[areaHeight];
        for (int y = 0; y < areaHeight; ++y) {
            float normalizedY = ((float)y - (float)areaHeight / 2.0f) / ((float)areaHeight / 2.0f);
            brightnessFactors[y] = 1.0f - normalizedY * normalizedY;
        }
        for (int i = 0; i < areaWidth; ++i) {
            int color = i / 1 % 2 == 0 ? -12582912 : -14680064;
            int width = Math.min(1, areaWidth - i);
            guiGraphics.fill(xStart + i, yStart, xStart + i + width, yStart + areaHeight, color);
        }
        float energyRatio = (float)((NetEnergyMenu)this.menu).energyStored / (float)((NetEnergyMenu)this.menu).energyCapacity;
        int filledWidth = (int)(energyRatio * (float)areaWidth);
        for (int i = 0; i < filledWidth; ++i) {
            int baseColor = i / 1 % 2 == 0 ? -65536 : -8388608;
            int drawWidth = Math.min(1, filledWidth - i);
            int alpha = baseColor >> 24 & 0xFF;
            int red = baseColor >> 16 & 0xFF;
            int green = baseColor >> 8 & 0xFF;
            int blue = baseColor & 0xFF;
            for (int y = 0; y < areaHeight; ++y) {
                int adjustedAlpha = (int)((float)alpha * brightnessFactors[y]);
                int adjustedColor = adjustedAlpha << 24 | red << 16 | green << 8 | blue;
                guiGraphics.fill(xStart + i, yStart + y, xStart + i + drawWidth, yStart + y + 1, adjustedColor);
            }
        }
    }

    public Font getFont() {
        return this.font;
    }
}

