/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.ReverseButton;
import com.wintercogs.beyonddimensions.Integration.EMI.SlotHandler.SlotDragHandler;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Packet.CallSeverClickPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverStoragePacket;
import com.wintercogs.beyonddimensions.Packet.FlagSlotSetPacket;
import com.wintercogs.beyonddimensions.Packet.PopModeButtonPacket;
import com.wintercogs.beyonddimensions.Registry.StackTypeRegistry;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetInterfaceBaseGUI
extends AbstractContainerScreen<NetInterfaceBaseMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.parse((String)"beyonddimensions:textures/gui/net_interface.png");
    public ReverseButton popButton;
    private SlotDragHandler dragHandler;
    private EmiIngredient dragIngredient;
    private boolean isDragging = false;

    public NetInterfaceBaseGUI(NetInterfaceBaseMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 207;
    }

    protected void init() {
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - 235) / 2;
        if (BeyondDimensions.EMILoaded) {
            this.dragHandler = new SlotDragHandler(slot -> {
                if (slot instanceof StoredStackSlot) {
                    StoredStackSlot sSlot = (StoredStackSlot)((Object)slot);
                    return sSlot.isFake();
                }
                return false;
            }, (slot, ingredient) -> {
                Object stackKey = ((EmiStack)ingredient.getEmiStacks().get(0)).getKey();
                long stackAmount = ((EmiStack)ingredient.getEmiStacks().get(0)).getAmount();
                DataComponentPatch dataComponentPatch = ((EmiStack)ingredient.getEmiStacks().get(0)).getComponentChanges();
                IStackType<ItemStack> dragging = new ItemStackType();
                for (IStackType<?> type : StackTypeRegistry.getAllTypes()) {
                    if (!type.getSourceClass().isAssignableFrom(stackKey.getClass())) continue;
                    dragging = type.fromObject(stackKey, 1L, dataComponentPatch);
                    break;
                }
                StoredStackSlot sSlot = (StoredStackSlot)((Object)slot);
                IStackType clickItem = sSlot.getVanillaActualStack();
                PacketDistributor.sendToServer((CustomPacketPayload)new FlagSlotSetPacket(sSlot.index, clickItem, dragging), (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
        }
        this.popButton = new ReverseButton(this.leftPos + 72 + 72 - 5, this.topPos + 6, button -> {
            this.popButton.toggleState();
            ((NetInterfaceBaseMenu)this.menu).popMode = !((NetInterfaceBaseMenu)this.menu).popMode;
            PacketDistributor.sendToServer((CustomPacketPayload)new PopModeButtonPacket(((NetInterfaceBaseMenu)this.menu).popMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        this.addRenderableWidget((GuiEventListener)this.popButton);
        ((NetInterfaceBaseMenu)this.menu).storageHandler.clearStorage();
        ((NetInterfaceBaseMenu)this.menu).suppressRemoteUpdates();
        PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverStoragePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void containerTick() {
        ((NetInterfaceBaseMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((NetInterfaceBaseMenu)this.menu).viewerStorageHandler.getStorage()));
        if (((NetInterfaceBaseMenu)this.menu).popMode) {
            this.popButton.setState(ButtonState.DISABLED);
        } else {
            this.popButton.setState(ButtonState.ENABLED);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.popButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY + 20, 0x404040, false);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof StoredStackSlot) {
            StoredStackSlot sSlot = (StoredStackSlot)slot;
            int x = slot.x;
            int y = slot.y;
            IStackType stack = sSlot.getStack();
            if (stack != null) {
                stack.render(guiGraphics, x, y);
            }
        } else {
            super.renderSlot(guiGraphics, slot);
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (((NetInterfaceBaseMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            Slot slot = this.hoveredSlot;
            if (slot instanceof StoredStackSlot) {
                StoredStackSlot sSlot = (StoredStackSlot)slot;
                IStackType stack = sSlot.getStack();
                stack.renderTooltip(guiGraphics, this.minecraft.font, x, y);
            } else {
                ItemStack itemstack = this.hoveredSlot.getItem();
                guiGraphics.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, x, y);
            }
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        if (scrollY > 0.0) {
            --((NetInterfaceBaseMenu)this.menu).lineData;
        } else if (scrollY < 0.0) {
            ++((NetInterfaceBaseMenu)this.menu).lineData;
        }
        ((NetInterfaceBaseMenu)this.menu).ScrollTo();
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot slot = this.findSlot(mouseX, mouseY);
        if (!(slot instanceof StoredStackSlot)) {
            super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        if (BeyondDimensions.EMILoaded && !this.isDragging) {
            this.dragIngredient = EmiApi.getHoveredStack((int)((int)mouseX), (int)((int)mouseY), (boolean)true).getStack();
            if (this.dragIngredient != null) {
                this.isDragging = true;
            }
        }
        ((NetInterfaceBaseMenu)this.menu).ScrollTo();
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        Slot slot = this.findSlot(mouseX, mouseY);
        if (slot != null && !((NetInterfaceBaseMenu)this.menu).isHanding) {
            int slotId = slot.index;
            if (NetInterfaceBaseGUI.hasShiftDown()) {
                IStackType clickItem;
                if (slot instanceof StoredStackSlot) {
                    StoredStackSlot sSlot = (StoredStackSlot)slot;
                    clickItem = sSlot.getVanillaActualStack();
                } else {
                    clickItem = new ItemStackType(slot.getItem());
                }
                ((NetInterfaceBaseMenu)this.menu).isHanding = true;
                PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverClickPacket(slotId, clickItem, button, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (slot instanceof StoredStackSlot) {
                StoredStackSlot sSlot = (StoredStackSlot)slot;
                if (sSlot.isFake()) {
                    IStackType clickItem = sSlot.getVanillaActualStack();
                    ((NetInterfaceBaseMenu)this.menu).isHanding = true;
                    PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverClickPacket(slotId, clickItem, button, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    IStackType clickItem = sSlot.getVanillaActualStack();
                    ((NetInterfaceBaseMenu)this.menu).isHanding = true;
                    PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverClickPacket(slotId, clickItem, button, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
        return true;
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null && !(slot instanceof StoredStackSlot)) {
            super.slotClicked(slot, slotId, mouseButton, type);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        super.mouseReleased(mouseX, mouseY, button);
        if (BeyondDimensions.EMILoaded) {
            if (this.dragIngredient != null) {
                this.dragHandler.dropStack(this, this.dragIngredient, (int)mouseX, (int)mouseY);
            }
            this.dragIngredient = null;
        }
        this.isDragging = false;
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean checkHotbarKeyPressed(int keyCode, int scanCode) {
        if (((NetInterfaceBaseMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null) {
            Slot slot = this.hoveredSlot;
            if (slot instanceof StoredStackSlot) {
                StoredStackSlot sSlot = (StoredStackSlot)slot;
            } else {
                if (this.minecraft.options.keySwapOffhand.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
                    this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, 40, ClickType.SWAP);
                    return true;
                }
                for (int i = 0; i < 9; ++i) {
                    if (!this.minecraft.options.keyHotbarSlots[i].isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) continue;
                    this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, i, ClickType.SWAP);
                    return true;
                }
            }
        }
        return false;
    }

    public Font getFont() {
        return this.font;
    }
}

