/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class NetedItem
extends Item {
    public static final Logger LOGGER = LogUtils.getLogger();

    public NetedItem(Item.Properties properties) {
        super(properties.component(ModDataComponents.NET_ID_DATA, (Object)-1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (level.isClientSide()) return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
        if (net == null) return InteractionResultHolder.fail((Object)itemstack);
        if (!this.validToReWrite(net, player)) return InteractionResultHolder.fail((Object)itemstack);
        if (((Integer)itemstack.get(ModDataComponents.NET_ID_DATA)).intValue() != net.getId()) {
            itemstack.set(ModDataComponents.NET_ID_DATA, (Object)net.getId());
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        } else {
            itemstack.set(ModDataComponents.NET_ID_DATA, (Object)-1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    protected boolean validToReWrite(DimensionsNet net, Player player) {
        return net.isManager(player);
    }
}

