/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.google.common.base.Suppliers;
import com.wintercogs.beyonddimensions.DataBase.ButtonName;
import com.wintercogs.beyonddimensions.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Packet.StoragePacket;
import com.wintercogs.beyonddimensions.Packet.SyncStoragePacket;
import com.wintercogs.beyonddimensions.Unit.TinyPinyinUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DimensionsNetMenu
extends AbstractContainerMenu {
    private final Player player;
    public final UnifiedStorage unifiedStorage;
    private int lines = 6;
    public int lineData = 0;
    public int maxLineData = 0;
    private String searchText = "";
    private HashMap<ButtonName, ButtonState> buttonStateMap = new HashMap();
    public boolean isHanding = false;
    public UnifiedStorage viewerUnifiedStorage;
    private ArrayList<IStackType> lastItemStorage;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<DimensionsNetMenu>> Dimensions_Net_Menu = MENU_TYPES.register("dimensions_net_menu", () -> IMenuTypeExtension.create(DimensionsNetMenu::new));

    public DimensionsNetMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, new DimensionsNet(), new SimpleContainerData(0));
    }

    public DimensionsNetMenu(int id, Inventory playerInventory, DimensionsNet data, SimpleContainerData uselessContainer) {
        super(Dimensions_Net_Menu.get(), id);
        int row;
        this.unifiedStorage = data.getUnifiedStorage();
        this.viewerUnifiedStorage = new DimensionsNet().getUnifiedStorage();
        this.player = playerInventory.player;
        if (!this.player.level().isClientSide()) {
            this.lastItemStorage = new ArrayList();
            for (IStackType stack : this.unifiedStorage.getStorage()) {
                this.lastItemStorage.add(stack.copy());
            }
        }
        this.buttonStateMap.put(ButtonName.ReverseButton, ButtonState.DISABLED);
        this.buttonStateMap.put(ButtonName.SortMethodButton, ButtonState.SORT_DEFAULT);
        for (row = 0; row < this.lines; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new StoredStackSlot(this.viewerUnifiedStorage, -1, 8 + col * 18, 27 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 149 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 207));
        }
    }

    public void updateViewerStorage() {
        this.viewerUnifiedStorage.clearStorage();
        for (IStackType stack : this.unifiedStorage.getStorage()) {
            this.viewerUnifiedStorage.insert(stack.copy(), false);
        }
        this.buildIndexList(new ArrayList<IStackType>(this.viewerUnifiedStorage.getStorage()));
    }

    public final void ScrollTo() {
        this.buildIndexList(new ArrayList<IStackType>(this.viewerUnifiedStorage.getStorage()));
    }

    public void loadSearchText(String text) {
        this.searchText = text.toLowerCase(Locale.ENGLISH);
    }

    public void loadButtonState(HashMap<ButtonName, ButtonState> buttonStateMap) {
        this.buttonStateMap = buttonStateMap;
    }

    public ArrayList<Integer> buildStorageWithCurrentState(ArrayList<IStackType> unifiedStorage) {
        ArrayList cache = new ArrayList();
        ArrayList<Integer> cacheIndex = new ArrayList<Integer>();
        for (int i = 0; i < unifiedStorage.size(); ++i) {
            boolean matchesSearch;
            IStackType stack = unifiedStorage.get(i).copy();
            if (stack == null || stack.isEmpty()) continue;
            String displayName = stack.getDisplayName().getString().toLowerCase(Locale.ENGLISH);
            String allPinyin = TinyPinyinUtils.getAllPinyin(displayName, false).toLowerCase(Locale.ENGLISH);
            String firstPinyin = TinyPinyinUtils.getFirstPinYin(displayName).toLowerCase(Locale.ENGLISH);
            boolean bl = matchesSearch = this.searchText == null || this.searchText.isEmpty() || displayName.contains(this.searchText) || allPinyin.contains(this.searchText) || firstPinyin.contains(this.searchText) || this.checkTooltipMatches(stack, this.searchText);
            if (!matchesSearch) continue;
            cache.add(stack);
            cacheIndex.add(i);
        }
        ButtonState sortState = this.buttonStateMap.get((Object)ButtonName.SortMethodButton);
        if (sortState != ButtonState.SORT_DEFAULT) {
            Comparator<IStackType> comparator = sortState == ButtonState.SORT_NAME ? Comparator.comparing(item -> item.getDisplayName().getString()) : Comparator.comparingLong(IStackType::getStackAmount);
            ArrayList finalCache = cache;
            List indices = IntStream.range(0, cache.size()).boxed().sorted((a, b) -> comparator.compare((IStackType)finalCache.get((int)a), (IStackType)finalCache.get((int)b))).collect(Collectors.toList());
            ArrayList<Integer> sortedIndices = new ArrayList<Integer>(cacheIndex.size());
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                sortedIndices.add(cacheIndex.get(index));
            }
            cacheIndex = sortedIndices;
        }
        if (this.buttonStateMap.get((Object)ButtonName.ReverseButton) == ButtonState.ENABLED) {
            Collections.reverse(cacheIndex);
        }
        return cacheIndex;
    }

    private boolean checkTooltipMatches(IStackType stack, String matchText) {
        List<Component> toolTips = stack.getTooltipLines(Item.TooltipContext.of((Level)this.player.level()), this.player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        return toolTips.stream().anyMatch(tooltip -> tooltip.getString().toLowerCase(Locale.ENGLISH).contains(matchText));
    }

    public void updateScrollLineData(int dataSize) {
        this.maxLineData = dataSize / 9;
        if (dataSize % 9 != 0) {
            ++this.maxLineData;
        }
        this.maxLineData -= this.lines;
        this.maxLineData = Math.max(this.maxLineData, 0);
        this.lineData = Math.max(this.lineData, 0);
        this.lineData = Math.min(this.lineData, this.maxLineData);
    }

    public void buildIndexList(ArrayList<IStackType> itemStorage) {
        if (!this.player.level().isClientSide()) {
            return;
        }
        ArrayList<Integer> cacheIndex = this.buildStorageWithCurrentState(new ArrayList<IStackType>(itemStorage));
        this.updateScrollLineData(cacheIndex.size());
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this.lines * 9; ++i) {
            if (i + this.lineData * 9 < cacheIndex.size()) {
                int index = cacheIndex.get(i + this.lineData * 9);
                indexList.add(index);
                continue;
            }
            indexList.add(-1);
        }
        this.loadIndexList(indexList);
    }

    public void broadcastChanges() {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot instanceof StoredStackSlot) continue;
            ItemStack itemstack = slot.getItem();
            Objects.requireNonNull(itemstack);
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).copy());
            this.triggerSlotListeners(i, itemstack, (Supplier)supplier);
            this.synchronizeSlotToRemote(i, itemstack, (Supplier)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (int j = 0; j < this.dataSlots.size(); ++j) {
            DataSlot dataslot = (DataSlot)this.dataSlots.get(j);
            int k = dataslot.get();
            if (dataslot.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(j, k);
            }
            this.synchronizeDataSlotToRemote(j, k);
        }
        ArrayList<IStackType> changedItem = new ArrayList<IStackType>();
        ArrayList<Long> changedCount = new ArrayList<Long>();
        ArrayList cacheLast = new ArrayList();
        for (IStackType iStackType : this.lastItemStorage) {
            cacheLast.add(iStackType.copy());
        }
        ArrayList cacheNow = new ArrayList();
        for (IStackType iStackType : this.unifiedStorage.getStorage()) {
            cacheNow.add(iStackType.copy());
        }
        this.refreshLast();
        HashMap<IStackType, Long> hashMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : cacheLast) {
            hashMap.put(iStackType, hashMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        HashMap<IStackType, Long> hashMap2 = new HashMap<IStackType, Long>();
        for (IStackType iStackType : cacheNow) {
            hashMap2.put(iStackType, hashMap2.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(hashMap.keySet());
        hashSet.addAll(hashMap2.keySet());
        for (IStackType key : hashSet) {
            long lastCount = hashMap.getOrDefault(key, 0L);
            long nowCount = hashMap2.getOrDefault(key, 0L);
            long delta = nowCount - lastCount;
            if (delta == 0L) continue;
            changedItem.add(key.copy());
            changedCount.add(delta);
        }
        if (!changedItem.isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new SyncStoragePacket(changedItem, changedCount, new ArrayList<Integer>(0)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void refreshLast() {
        this.lastItemStorage.clear();
        for (IStackType stack : this.unifiedStorage.getStorage()) {
            this.lastItemStorage.add(stack.copy());
        }
    }

    public void sendStorage() {
        if (this.player instanceof ServerPlayer) {
            ArrayList<StoragePacket> splitPackets = new ArrayList<StoragePacket>();
            ArrayList<IStackType> currentBatch = new ArrayList<IStackType>();
            ArrayList<Integer> currentIndices = new ArrayList<Integer>();
            int currentPayloadSize = 0;
            int MAX_PAYLOAD_SIZE = 900000;
            ArrayList<IStackType> storage = new ArrayList<IStackType>(this.unifiedStorage.getStorage());
            for (int i = 0; i < storage.size(); ++i) {
                boolean isLastItem;
                IStackType stack = storage.get(i);
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)buf, this.player.level().registryAccess(), ConnectionType.OTHER);
                stack.serialize(registryBuf);
                int entrySize = registryBuf.readableBytes() + 4 + 1;
                boolean bl = isLastItem = i == storage.size() - 1;
                if (currentPayloadSize + entrySize >= 900000) {
                    splitPackets.add(new StoragePacket(new ArrayList<IStackType>(currentBatch), new ArrayList<Integer>(currentIndices), false));
                    currentBatch.clear();
                    currentIndices.clear();
                    currentPayloadSize = 0;
                }
                currentBatch.add(stack);
                currentIndices.add(i);
                currentPayloadSize += entrySize;
                if (!isLastItem) continue;
                splitPackets.add(new StoragePacket(new ArrayList<IStackType>(currentBatch), new ArrayList<Integer>(currentIndices), true));
            }
            if (!splitPackets.isEmpty()) {
                StoragePacket firstPacket = (StoragePacket)splitPackets.get(0);
                CustomPacketPayload[] remainingPackets = splitPackets.subList(1, splitPackets.size()).toArray(new StoragePacket[0]);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)firstPacket, (CustomPacketPayload[])remainingPackets);
            }
        }
    }

    public void loadIndexList(ArrayList<Integer> list) {
        for (int i = 0; i < list.size(); ++i) {
            ((StoredStackSlot)((Object)this.slots.get(i))).setTheSlotIndex(list.get(i));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void customClickHandler(int slotIndex, IStackType clickedStack, int button, boolean shiftDown) {
        UnifiedStorage trueItemStorage = this.unifiedStorage;
        if (shiftDown) {
            this.quickMoveHandle(this.player, slotIndex, clickedStack, trueItemStorage);
        } else {
            this.clickHandle(slotIndex, clickedStack, button, this.player, trueItemStorage);
        }
    }

    protected ItemStack quickMoveHandle(Player player, int slotIndex, IStackType clickStack, UnifiedStorage unifiedStorage) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && !clickStack.isEmpty()) {
            ItemStack cacheStack;
            if (slot instanceof StoredStackSlot) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickedItem = (ItemStackType)clickStack;
                    cacheStack = clickedItem.copyStack();
                    int moveCount = this.checkCanMoveStackCount(cacheStack, this.lines * 9, this.slots.size(), true);
                    moveCount = Math.min(moveCount, cacheStack.getCount());
                    int nowCount = 0;
                    IStackType typedStack = unifiedStorage.getStackByStack(StackCreater.Create(ItemStackType.ID, cacheStack.copy(), cacheStack.getCount()));
                    if (typedStack == null) {
                        return ItemStack.EMPTY;
                    }
                    ItemStack nowStack = (ItemStack)typedStack.getStack();
                    if (nowStack != null) {
                        nowCount = nowStack.getCount();
                    }
                    if ((moveCount = Math.min(moveCount, nowCount)) >= 0) {
                        cacheStack.setCount(moveCount);
                        if (!this.moveItemStackTo(cacheStack, this.lines * 9, this.slots.size(), true)) {
                            return ItemStack.EMPTY;
                        }
                        unifiedStorage.extract(StackCreater.Create(ItemStackType.ID, clickStack.copyStackWithCount(moveCount), moveCount), false);
                    }
                } else {
                    cacheStack = ItemStack.EMPTY;
                }
            } else {
                cacheStack = slot.getItem().copy();
                unifiedStorage.insert(StackCreater.Create(ItemStackType.ID, cacheStack.copy(), cacheStack.getCount()), false);
                slot.tryRemove(cacheStack.getCount(), 0x7FFFFFFE, player);
            }
            if (cacheStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return ItemStack.EMPTY;
    }

    protected void clickHandle(int slotIndex, IStackType clickStack, int button, Player player, UnifiedStorage unifiedStorage) {
        ItemStack carriedItem = this.getCarried().copy();
        StoredStackSlot slot = (StoredStackSlot)((Object)this.slots.get(slotIndex));
        if (clickStack.isEmpty()) {
            if (!carriedItem.isEmpty()) {
                int changedCount = button == 0 ? carriedItem.getCount() : 1;
                unifiedStorage.insert(StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false);
                int newCount = carriedItem.getCount() - changedCount;
                if (newCount <= 0) {
                    this.setCarried(ItemStack.EMPTY);
                } else {
                    ItemStack newCarriedItem = carriedItem.copy();
                    newCarriedItem.setCount(newCount);
                    this.setCarried(newCarriedItem);
                }
            }
        } else if (slot.mayPickup(player) && clickStack instanceof ItemStackType) {
            ItemStackType clickItem = (ItemStackType)clickStack;
            if (carriedItem.isEmpty()) {
                int woundChangeNum = (int)Math.min(clickItem.getStackAmount(), clickItem.getVanillaMaxStackSize());
                int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
                ItemStack takenItem = ((ItemStack)unifiedStorage.extract(new ItemStackType(clickItem.copyStackWithCount(actualChangeNum)), false).getStack()).copy();
                if (takenItem != null) {
                    this.setCarried(takenItem);
                    unifiedStorage.onChange();
                }
            } else if (slot.mayPlace(carriedItem)) {
                int changedCount = button == 0 ? carriedItem.getCount() : 1;
                unifiedStorage.insert(StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false);
                int newCount = carriedItem.getCount() - changedCount;
                if (newCount <= 0) {
                    this.setCarried(ItemStack.EMPTY);
                } else {
                    ItemStack newCarriedItem = carriedItem.copy();
                    newCarriedItem.setCount(newCount);
                    this.setCarried(newCarriedItem);
                }
            } else if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.copy()))) {
                // empty if block
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            if (this.slots.get(i) instanceof StoredStackSlot) {
                this.unifiedStorage.insert(StackCreater.Create(ItemStackType.ID, stack.copy(), stack.getCount()), false);
                flag = true;
                break;
            }
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                int k;
                int j = itemstack.getCount() + stack.getCount();
                if (j <= (k = slot.getMaxStackSize(itemstack))) {
                    stack.setCount(0);
                    itemstack.setCount(j);
                    slot.setChanged();
                    flag = true;
                } else if (itemstack.getCount() < k) {
                    stack.shrink(k - itemstack.getCount());
                    itemstack.setCount(k);
                    slot.setChanged();
                    flag = true;
                }
            }
            if (itemstack.isEmpty() && slot.mayPlace(stack)) {
                int l = slot.getMaxStackSize(stack);
                slot.setByPlayer(stack.split(Math.min(stack.getCount(), l)));
                slot.setChanged();
                flag = true;
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        return flag;
    }

    protected int checkCanMoveStackCount(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        int flag = 0;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            if (this.slots.get(i) instanceof StoredStackSlot) {
                flag = stack.getMaxStackSize();
                break;
            }
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                int k = slot.getMaxStackSize(itemstack);
                int maxCanPut = k - itemstack.getCount();
                flag += maxCanPut;
            }
            if (itemstack.isEmpty() && slot.mayPlace(stack)) {
                int l = slot.getMaxStackSize(stack);
                flag += l;
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        return flag;
    }

    public static class ItemStackedOnOtherHandler {
        @SubscribeEvent
        public void OnItemStackedHandle(ItemStackedOnOtherEvent event) {
            event.setCanceled(event.getSlot() instanceof StoredStackSlot);
        }
    }
}

