/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetEnergyPathwayBlockEntity;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Storage.EnergyStorage;
import com.wintercogs.beyonddimensions.Packet.EnergyStoragePacket;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NetEnergyMenu
extends AbstractContainerMenu {
    private final Player player;
    public boolean popMode = false;
    public NetEnergyPathwayBlockEntity be;
    private EnergyStorage energyStorage = null;
    public long energyCapacity = 0L;
    public long energyStored = 0L;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<NetEnergyMenu>> Net_Energy_Menu = MENU_TYPES.register("net_energy_menu", () -> IMenuTypeExtension.create(NetEnergyMenu::new));

    public NetEnergyMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, null, new SimpleContainerData(0));
    }

    public NetEnergyMenu(int id, Inventory playerInventory, NetEnergyPathwayBlockEntity be, SimpleContainerData uselessContainer) {
        super(Net_Energy_Menu.get(), id);
        this.player = playerInventory.player;
        if (!this.player.level().isClientSide()) {
            this.popMode = be.popMode;
            this.be = be;
            DimensionsNet net = be.getNet();
            if (net != null) {
                this.energyStorage = be.getNet().getEnergyStorage();
            }
            if (this.energyStorage != null) {
                this.energyCapacity = this.energyStorage.getRealEnergyCapacity();
                this.energyStored = this.energyStorage.getRealEnergyStored();
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 93 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 151));
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.energyStorage != null && (this.energyStorage.getRealEnergyCapacity() != this.energyCapacity || this.energyStored != this.energyCapacity)) {
            this.energyCapacity = this.energyStorage.getRealEnergyCapacity();
            this.energyStored = this.energyStorage.getRealEnergyStored();
            this.sendStorage();
        }
    }

    public void sendStorage() {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new EnergyStoragePacket(this.energyStored, this.energyCapacity), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void loadStorage(long energyCapacity, long energyStored) {
        this.energyCapacity = energyCapacity;
        this.energyStored = energyStored;
    }

    public ItemStack quickMoveStack(Player player, int i) {
        return null;
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

