/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetInterfaceBlockEntity;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Packet.StoragePacket;
import com.wintercogs.beyonddimensions.Packet.SyncFlagPacket;
import com.wintercogs.beyonddimensions.Packet.SyncStoragePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class NetInterfaceBaseMenu
extends AbstractContainerMenu {
    private final Player player;
    public final StackTypedHandler storageHandler;
    private int lines = 1;
    public int lineData = 0;
    public int maxLineData = 0;
    public boolean isHanding = false;
    public StackTypedHandler viewerStorageHandler;
    private ArrayList<IStackType> lastStorageHandler;
    public final StackTypedHandler flagStorage;
    public StackTypedHandler viewerFlagStorage;
    public ArrayList<IStackType> lastFlagStorage;
    public boolean popMode = false;
    public NetInterfaceBlockEntity be;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final java.util.function.Supplier<MenuType<NetInterfaceBaseMenu>> Net_Interface_Menu = MENU_TYPES.register("net_interface_menu", () -> IMenuTypeExtension.create(NetInterfaceBaseMenu::new));

    public NetInterfaceBaseMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, new StackTypedHandler(9), new StackTypedHandler(9), null, new SimpleContainerData(0));
    }

    public NetInterfaceBaseMenu(int id, Inventory playerInventory, StackTypedHandler storage, StackTypedHandler flagStorage, NetInterfaceBlockEntity be, SimpleContainerData uselessContainer) {
        super(Net_Interface_Menu.get(), id);
        int col;
        this.storageHandler = storage;
        this.viewerStorageHandler = new StackTypedHandler(9);
        this.player = playerInventory.player;
        if (!this.player.level().isClientSide()) {
            this.lastStorageHandler = new ArrayList();
            for (IStackType stack : this.storageHandler.getStorage()) {
                this.lastStorageHandler.add(stack.copy());
            }
            this.popMode = be.popMode;
            this.be = be;
        }
        this.flagStorage = flagStorage;
        this.viewerFlagStorage = new StackTypedHandler(9);
        if (!this.player.level().isClientSide()) {
            this.lastFlagStorage = new ArrayList();
            for (IStackType stack : this.flagStorage.getStorage()) {
                this.lastFlagStorage.add(new ItemStackType());
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new StoredStackSlot(this.viewerStorageHandler, col, 8 + col * 18, 71));
        }
        for (int i = 0; i < flagStorage.getStorage().size(); ++i) {
            StoredStackSlot flagSlot = new StoredStackSlot(this.viewerFlagStorage, i, 8 + i * 18, 53);
            flagSlot.setFake(true);
            this.addSlot(flagSlot);
        }
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.addSlot(new Slot((Container)playerInventory, col2 + row * 9 + 9, 8 + col2 * 18, 123 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 181));
        }
    }

    public void updateViewerStorage() {
        for (IStackType stack : this.viewerStorageHandler.getStorage()) {
            stack.setStackAmount(-1L);
        }
        for (int i = 0; i < this.storageHandler.getStorage().size(); ++i) {
            this.viewerStorageHandler.insert(i, this.storageHandler.getStackBySlot(i), false);
        }
        this.buildIndexList(new ArrayList<IStackType>(this.viewerStorageHandler.getStorage()));
        for (IStackType stack : this.viewerFlagStorage.getStorage()) {
            stack.setStackAmount(-1L);
        }
        for (int i = 0; i < this.flagStorage.getStorage().size(); ++i) {
            this.viewerFlagStorage.insert(i, this.flagStorage.getStackBySlot(i), false);
        }
        this.buildIndexList(new ArrayList<IStackType>(this.viewerFlagStorage.getStorage()));
    }

    public final void ScrollTo() {
        this.buildIndexList(new ArrayList<IStackType>(this.viewerStorageHandler.getStorage()));
        this.buildIndexList(new ArrayList<IStackType>(this.viewerFlagStorage.getStorage()));
    }

    public ArrayList<Integer> buildStorageWithCurrentState(ArrayList<IStackType> unifiedStorage) {
        ArrayList cache = new ArrayList();
        ArrayList<Integer> cacheIndex = new ArrayList<Integer>();
        for (int i = 0; i < unifiedStorage.size(); ++i) {
            IStackType stack = unifiedStorage.get(i).copy();
            if (stack == null) continue;
            cache.add(stack);
            cacheIndex.add(i);
        }
        return cacheIndex;
    }

    public void updateScrollLineData(int dataSize) {
        this.maxLineData = dataSize / 9;
        if (dataSize % 9 != 0) {
            ++this.maxLineData;
        }
        this.maxLineData -= this.lines;
        this.maxLineData = Math.max(this.maxLineData, 0);
        this.lineData = Math.max(this.lineData, 0);
        this.lineData = Math.min(this.lineData, this.maxLineData);
    }

    public void buildIndexList(ArrayList<IStackType> itemStorage) {
        if (!this.player.level().isClientSide()) {
            return;
        }
        ArrayList<Integer> cacheIndex = this.buildStorageWithCurrentState(new ArrayList<IStackType>(itemStorage));
        this.updateScrollLineData(cacheIndex.size());
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this.lines * 9; ++i) {
            if (i + this.lineData * 9 < cacheIndex.size()) {
                int index = cacheIndex.get(i + this.lineData * 9);
                indexList.add(index);
                continue;
            }
            indexList.add(-1);
        }
    }

    public void broadcastChanges() {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot instanceof StoredStackSlot) continue;
            ItemStack itemstack = slot.getItem();
            Objects.requireNonNull(itemstack);
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).copy());
            this.triggerSlotListeners(i, itemstack, (java.util.function.Supplier)supplier);
            this.synchronizeSlotToRemote(i, itemstack, (java.util.function.Supplier)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (int j = 0; j < this.dataSlots.size(); ++j) {
            DataSlot dataslot = (DataSlot)this.dataSlots.get(j);
            int k = dataslot.get();
            if (dataslot.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(j, k);
            }
            this.synchronizeDataSlotToRemote(j, k);
        }
        ArrayList<IStackType> changedItems = new ArrayList<IStackType>();
        ArrayList<Long> changedCounts = new ArrayList<Long>();
        ArrayList<Integer> changedIndices = new ArrayList<Integer>();
        ArrayList<@Nullable IStackType<T>> lastSnapshot = new ArrayList();
        for (IStackType iStackType : this.lastStorageHandler) {
            lastSnapshot.add(iStackType != null ? iStackType.copy() : null);
        }
        ArrayList<@Nullable IStackType<T>> currentSnapshot = new ArrayList();
        for (IStackType stack : this.storageHandler.getStorage()) {
            currentSnapshot.add(stack != null ? stack.copy() : null);
        }
        int n = Math.max(lastSnapshot.size(), currentSnapshot.size());
        while (lastSnapshot.size() < n) {
            lastSnapshot.add(null);
        }
        while (currentSnapshot.size() < n) {
            currentSnapshot.add(null);
        }
        for (int slot = 0; slot < n; ++slot) {
            IStackType lastStack = (IStackType)lastSnapshot.get(slot);
            IStackType currentStack = (IStackType)currentSnapshot.get(slot);
            boolean stackChanged = false;
            if (lastStack == null != (currentStack == null)) {
                stackChanged = true;
            } else if (lastStack != null && currentStack != null && !lastStack.isSameTypeSameComponents(currentStack)) {
                stackChanged = true;
            }
            long delta = (currentStack != null ? currentStack.getStackAmount() : 0L) - (lastStack != null ? lastStack.getStackAmount() : 0L);
            if (delta != 0L) {
                stackChanged = true;
            }
            if (!stackChanged) continue;
            changedIndices.add(slot);
            changedItems.add(currentStack != null ? currentStack.copy() : null);
            changedCounts.add(delta);
        }
        if (!changedIndices.isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new SyncStoragePacket(changedItems, changedCounts, changedIndices), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.lastStorageHandler.clear();
        this.lastStorageHandler.addAll(currentSnapshot);
        ArrayList<IStackType> changedFlags = new ArrayList<IStackType>();
        ArrayList<Integer> changedFlagIndices = new ArrayList<Integer>();
        ArrayList<@Nullable IStackType<T>> lastFlagSnapshot = new ArrayList();
        for (IStackType stack : this.lastFlagStorage) {
            lastFlagSnapshot.add(stack != null ? stack.copy() : null);
        }
        ArrayList<@Nullable IStackType<T>> currentFlagSnapshot = new ArrayList();
        for (IStackType stack : this.flagStorage.getStorage()) {
            currentFlagSnapshot.add(stack != null ? stack.copy() : null);
        }
        int maxFlagSlots = Math.max(lastFlagSnapshot.size(), currentFlagSnapshot.size());
        while (lastFlagSnapshot.size() < maxFlagSlots) {
            lastFlagSnapshot.add(null);
        }
        while (currentFlagSnapshot.size() < maxFlagSlots) {
            currentFlagSnapshot.add(null);
        }
        for (int slot = 0; slot < maxFlagSlots; ++slot) {
            IStackType lastStack = (IStackType)lastFlagSnapshot.get(slot);
            IStackType currentStack = (IStackType)currentFlagSnapshot.get(slot);
            boolean stackChanged = false;
            if (lastStack == null != (currentStack == null)) {
                stackChanged = true;
            } else if (lastStack != null && currentStack != null && !lastStack.isSameTypeSameComponents(currentStack)) {
                stackChanged = true;
            }
            if (!stackChanged) continue;
            changedFlagIndices.add(slot);
            changedFlags.add(currentStack != null ? currentStack.copy() : null);
        }
        if (!changedFlagIndices.isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new SyncFlagPacket(changedFlags, changedFlagIndices), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.lastFlagStorage.clear();
        this.lastFlagStorage.addAll(currentFlagSnapshot);
    }

    public void refreshLast() {
        this.lastStorageHandler.clear();
        for (IStackType stack : this.storageHandler.getStorage()) {
            this.lastStorageHandler.add(stack.copy());
        }
        this.lastFlagStorage.clear();
        for (IStackType stack : this.flagStorage.getStorage()) {
            this.lastFlagStorage.add(stack.copy());
        }
    }

    public void sendStorage() {
        if (this.player instanceof ServerPlayer) {
            ArrayList<StoragePacket> splitPackets = new ArrayList<StoragePacket>();
            ArrayList<IStackType> currentBatch = new ArrayList<IStackType>();
            ArrayList<Integer> currentIndices = new ArrayList<Integer>();
            int currentPayloadSize = 0;
            int MAX_PAYLOAD_SIZE = 900000;
            ArrayList<IStackType> storage = new ArrayList<IStackType>(this.storageHandler.getStorage());
            for (int i = 0; i < storage.size(); ++i) {
                boolean isLastItem;
                IStackType stack = storage.get(i);
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)buf, this.player.level().registryAccess(), ConnectionType.OTHER);
                stack.serialize(registryBuf);
                int entrySize = registryBuf.readableBytes() + 4 + 1;
                boolean bl = isLastItem = i == storage.size() - 1;
                if (currentPayloadSize + entrySize >= 900000) {
                    splitPackets.add(new StoragePacket(new ArrayList<IStackType>(currentBatch), new ArrayList<Integer>(currentIndices), false));
                    currentBatch.clear();
                    currentIndices.clear();
                    currentPayloadSize = 0;
                }
                currentBatch.add(stack);
                currentIndices.add(i);
                currentPayloadSize += entrySize;
                if (!isLastItem) continue;
                splitPackets.add(new StoragePacket(new ArrayList<IStackType>(currentBatch), new ArrayList<Integer>(currentIndices), true));
            }
            if (!splitPackets.isEmpty()) {
                StoragePacket firstPacket = (StoragePacket)splitPackets.get(0);
                CustomPacketPayload[] remainingPackets = splitPackets.subList(1, splitPackets.size()).toArray(new StoragePacket[0]);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)firstPacket, (CustomPacketPayload[])remainingPackets);
            }
        }
    }

    public void loadIndexList(ArrayList<Integer> list) {
        for (int i = 0; i < list.size(); ++i) {
            ((StoredStackSlot)((Object)this.slots.get(i))).setTheSlotIndex(list.get(i));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void customClickHandler(int slotIndex, IStackType clickedStack, int button, boolean shiftDown) {
        StackTypedHandler trueItemStorage = this.storageHandler;
        if (shiftDown) {
            this.quickMoveHandle(this.player, slotIndex, clickedStack, trueItemStorage);
        } else {
            this.clickHandle(slotIndex, clickedStack, button, this.player, trueItemStorage);
        }
    }

    public void setFlagSlot(int slotIndex, IStackType clickStack, IStackType flagStack) {
        StoredStackSlot slot = (StoredStackSlot)((Object)this.slots.get(slotIndex));
        if (slot.isFake()) {
            if (flagStack.isEmpty() && this.getCarried().isEmpty()) {
                this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType());
            } else {
                this.flagStorage.setStackDirectly(slot.getSlotIndex(), flagStack);
            }
            return;
        }
    }

    protected ItemStack quickMoveHandle(Player player, int slotIndex, IStackType clickStack, IStackTypedHandler unifiedStorage) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && !clickStack.isEmpty()) {
            ItemStack cacheStack;
            if (slot instanceof StoredStackSlot) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickedItem = (ItemStackType)clickStack;
                    cacheStack = clickedItem.copyStack();
                    int moveCount = this.checkCanMoveStackCount(cacheStack, this.lines * 9, this.slots.size(), true);
                    moveCount = Math.min(moveCount, cacheStack.getCount());
                    int nowCount = 0;
                    IStackType typedStack = unifiedStorage.getStackBySlot(slot.getSlotIndex());
                    if (typedStack == null) {
                        return ItemStack.EMPTY;
                    }
                    ItemStack nowStack = (ItemStack)typedStack.getStack();
                    if (nowStack != null) {
                        nowCount = nowStack.getCount();
                    }
                    if ((moveCount = Math.min(moveCount, nowCount)) >= 0) {
                        cacheStack.setCount(moveCount);
                        if (!this.moveItemStackTo(cacheStack, this.lines * 9, this.slots.size(), true)) {
                            return ItemStack.EMPTY;
                        }
                        unifiedStorage.extract(slot.getSlotIndex(), moveCount, false);
                    }
                } else {
                    cacheStack = ItemStack.EMPTY;
                }
            } else {
                cacheStack = slot.getItem().copy();
                int remaining = (int)unifiedStorage.insert(StackCreater.Create(ItemStackType.ID, cacheStack.copy(), cacheStack.getCount()), false).getStackAmount();
                slot.tryRemove(cacheStack.getCount() - remaining, 0x7FFFFFFE, player);
            }
            if (cacheStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return ItemStack.EMPTY;
    }

    protected void clickHandle(int slotIndex, IStackType clickStack, int button, Player player, IStackTypedHandler unifiedStorage) {
        ItemStack carriedItem = this.getCarried().copy();
        StoredStackSlot slot = (StoredStackSlot)((Object)this.slots.get(slotIndex));
        if (slot.isFake()) {
            if (carriedItem.isEmpty()) {
                this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType());
            } else {
                this.flagStorage.setStackDirectly(slot.getSlotIndex(), new ItemStackType(carriedItem.copyWithCount(1)));
            }
            return;
        }
        if (clickStack.isEmpty()) {
            if (!carriedItem.isEmpty()) {
                int changedCount = button == 0 ? carriedItem.getCount() : 1;
                int remaining = (int)unifiedStorage.insert(slot.getSlotIndex(), StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false).getStackAmount();
                int actualInsert = changedCount - remaining;
                int newCount = carriedItem.getCount() - actualInsert;
                if (newCount <= 0) {
                    this.setCarried(ItemStack.EMPTY);
                } else {
                    ItemStack newCarriedItem = carriedItem.copy();
                    newCarriedItem.setCount(newCount);
                    this.setCarried(newCarriedItem);
                }
            }
        } else if (slot.mayPickup(player) && clickStack instanceof ItemStackType) {
            ItemStackType clickItem = (ItemStackType)clickStack;
            if (carriedItem.isEmpty()) {
                int woundChangeNum = (int)Math.min(clickItem.getStackAmount(), clickItem.getVanillaMaxStackSize());
                int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
                ItemStack takenItem = ((ItemStack)unifiedStorage.extract(slot.getSlotIndex(), actualChangeNum, false).getStack()).copy();
                if (takenItem != null) {
                    this.setCarried(takenItem);
                    unifiedStorage.onChange();
                }
            } else if (slot.mayPlace(carriedItem)) {
                if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.copy()))) {
                    int changedCount = button == 0 ? carriedItem.getCount() : 1;
                    int remaining = (int)unifiedStorage.insert(slot.getSlotIndex(), StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false).getStackAmount();
                    int actualInsert = changedCount - remaining;
                    int newCount = carriedItem.getCount() - actualInsert;
                    if (newCount <= 0) {
                        this.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newCarriedItem = carriedItem.copy();
                        newCarriedItem.setCount(newCount);
                        this.setCarried(newCarriedItem);
                    }
                }
            } else if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.copy()))) {
                // empty if block
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            if (this.slots.get(i) instanceof StoredStackSlot) {
                this.storageHandler.insert(StackCreater.Create(ItemStackType.ID, stack.copy(), stack.getCount()), false);
                flag = true;
                break;
            }
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                int k;
                int j = itemstack.getCount() + stack.getCount();
                if (j <= (k = slot.getMaxStackSize(itemstack))) {
                    stack.setCount(0);
                    itemstack.setCount(j);
                    slot.setChanged();
                    flag = true;
                } else if (itemstack.getCount() < k) {
                    stack.shrink(k - itemstack.getCount());
                    itemstack.setCount(k);
                    slot.setChanged();
                    flag = true;
                }
            }
            if (itemstack.isEmpty() && slot.mayPlace(stack)) {
                int l = slot.getMaxStackSize(stack);
                slot.setByPlayer(stack.split(Math.min(stack.getCount(), l)));
                slot.setChanged();
                flag = true;
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        return flag;
    }

    protected int checkCanMoveStackCount(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        int flag = 0;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            if (this.slots.get(i) instanceof StoredStackSlot) {
                flag = stack.getMaxStackSize();
                break;
            }
            Slot slot = (Slot)this.slots.get(i);
            ItemStack itemstack = slot.getItem();
            if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                int k = slot.getMaxStackSize(itemstack);
                int maxCanPut = k - itemstack.getCount();
                flag += maxCanPut;
            }
            if (itemstack.isEmpty() && slot.mayPlace(stack)) {
                int l = slot.getMaxStackSize(stack);
                flag += l;
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        return flag;
    }

    public static class ItemStackedOnOtherHandler {
        @SubscribeEvent
        public void OnItemStackedHandle(ItemStackedOnOtherEvent event) {
            event.setCanceled(event.getSlot() instanceof StoredStackSlot);
        }
    }
}

