/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class StoredStackSlot
extends Slot {
    private static final Container empty_inv = new SimpleContainer(0);
    private final IStackTypedHandler stackTypedHandler;
    private int theSlot;
    private boolean fake;

    public StoredStackSlot(IStackTypedHandler stackTypedHandler, int slotIndex, int xPosition, int yPosition) {
        super(empty_inv, slotIndex, xPosition, yPosition);
        this.theSlot = slotIndex;
        this.stackTypedHandler = stackTypedHandler;
    }

    public IStackType getTypedStackFromUnifiedStorage() {
        IStackType stackType = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        if (stackType != null) {
            return stackType.copy();
        }
        return new ItemStackType();
    }

    public ItemStack getItemStackFromUnifiedStorage() {
        IStackType stackType = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        if (stackType == null) {
            return ItemStack.EMPTY;
        }
        if (stackType instanceof ItemStackType) {
            ItemStackType itemStackType = (ItemStackType)stackType;
            return itemStackType.getStack();
        }
        return ItemStack.EMPTY;
    }

    public IStackType getVanillaActualStack() {
        IStackType stack = this.getTypedStackFromUnifiedStorage();
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack != null) {
            if (stack.getStackAmount() > stack.getVanillaMaxStackSize()) {
                return stack.copyWithCount(stack.getVanillaMaxStackSize());
            }
            return stack.copy();
        }
        return new ItemStackType();
    }

    public IStackType getVanillaMaxSizeStack() {
        IStackType stack = this.getTypedStackFromUnifiedStorage();
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack != null) {
            return stack.copyWithCount(stack.getVanillaMaxStackSize());
        }
        return new ItemStackType();
    }

    public IStackType getStack() {
        if (this.getSlotIndex() < 0 || this.getSlotIndex() >= this.stackTypedHandler.getSlots()) {
            return new ItemStackType(ItemStack.EMPTY);
        }
        IStackType stack = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        if (stack.isEmpty()) {
            return StackCreater.CreateEmpty(stack.getTypeId());
        }
        if (stack != null) {
            return stack.copy();
        }
        return new ItemStackType(ItemStack.EMPTY);
    }

    public ItemStack getItem() {
        if (this.getSlotIndex() < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = this.getItemStackFromUnifiedStorage();
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (itemStack != null) {
            return itemStack.copy();
        }
        return ItemStack.EMPTY;
    }

    public boolean hasItem() {
        return this.stackTypedHandler.getStackBySlot(this.getSlotIndex()) != null && !this.stackTypedHandler.getStackBySlot(this.getSlotIndex()).isEmpty();
    }

    public void set(ItemStack stack) {
        if (stack == ItemStack.EMPTY || stack == null || this.getSlotIndex() < 0) {
            return;
        }
        if (this.stackTypedHandler.getStorage().size() > this.getSlotIndex()) {
            this.stackTypedHandler.setStackDirectly(this.getSlotIndex(), new ItemStackType(stack.copy()));
        } else if (this.stackTypedHandler.getStorage().size() == this.getSlotIndex()) {
            this.stackTypedHandler.addStackToIndexDirectly(this.getSlotIndex(), new ItemStackType(stack.copy()));
        } else {
            while (this.stackTypedHandler.getStorage().size() < this.getSlotIndex()) {
                this.stackTypedHandler.addStackDirectly(new ItemStackType(ItemStack.EMPTY));
            }
            this.stackTypedHandler.addStackToIndexDirectly(this.getSlotIndex(), new ItemStackType(stack.copy()));
        }
        this.setChanged();
    }

    public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
        this.stackTypedHandler.insert(new ItemStackType(newStack.copy()), false);
        this.setChanged();
    }

    public void setChanged() {
        this.stackTypedHandler.onChange();
    }

    public int getMaxStackSize() {
        return 0x7FFFFFFE;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 0x7FFFFFFE;
    }

    public ItemStack remove(int amount) {
        if (this.getItem() == ItemStack.EMPTY || this.getItem() == null) {
            return ItemStack.EMPTY;
        }
        IStackType typedStack = this.stackTypedHandler.extract(this.getSlotIndex(), amount, true);
        if (typedStack instanceof ItemStackType) {
            ItemStackType trueExtract = (ItemStackType)this.stackTypedHandler.extract(this.getSlotIndex(), amount, false);
            return trueExtract.copyStack();
        }
        return ItemStack.EMPTY;
    }

    public int getSlotIndex() {
        return this.theSlot;
    }

    public boolean isSameInventory(Slot other) {
        if (other instanceof StoredStackSlot) {
            return this.stackTypedHandler == ((StoredStackSlot)other).stackTypedHandler;
        }
        return false;
    }

    public ItemStack safeInsert(ItemStack stack, int increment) {
        if (!stack.isEmpty() && this.mayPlace(stack)) {
            ItemStack itemstack = this.getItem();
            int i = Math.min(Math.min(increment, stack.getCount()), this.getMaxStackSize(stack) - itemstack.getCount());
            this.setByPlayer(stack.split(i));
        }
        return stack;
    }

    public int getContainerSlot() {
        return this.theSlot;
    }

    public void setTheSlotIndex(int index) {
        this.theSlot = index;
    }

    public long getItemCount() {
        if (this.getSlotIndex() < 0) {
            return -1L;
        }
        IStackType stack = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        if (stack != null && !stack.isEmpty()) {
            return stack.getStackAmount();
        }
        return -1L;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setFake(boolean fake) {
        this.fake = fake;
    }
}

