/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Unit;

import com.github.promeg.pinyinhelper.Pinyin;
import com.github.promeg.pinyinhelper.PinyinDict;
import com.github.promeg.tinypinyin.lexicons.java.cncity.CnCityDict;
import com.wintercogs.beyonddimensions.BeyondDimensions;

public class TinyPinyinUtils {
    public static String getFirstPinYin(String hanyu) {
        char[] chars;
        StringBuilder firstPinyin = new StringBuilder();
        for (char c : chars = hanyu.trim().toCharArray()) {
            if (Pinyin.isChinese((char)c)) {
                String pinyin = Pinyin.toPinyin((char)c);
                if (pinyin.isEmpty()) continue;
                firstPinyin.append(pinyin.charAt(0));
                continue;
            }
            firstPinyin.append(c);
        }
        return firstPinyin.toString();
    }

    public static String getAllPinyin(String hanzi, boolean addSpace) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        for (char c : chars = hanzi.trim().toCharArray()) {
            if (Pinyin.isChinese((char)c)) {
                result.append(Pinyin.toPinyin((char)c));
            } else {
                result.append(c);
            }
            if (!addSpace) continue;
            result.append(' ');
        }
        if (addSpace && result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    static {
        Pinyin.init((Pinyin.Config)Pinyin.newConfig().with((PinyinDict)CnCityDict.getInstance()));
        BeyondDimensions.LOGGER.info(TinyPinyinUtils.getFirstPinYin("\u897f\u74dc"));
        BeyondDimensions.LOGGER.info(TinyPinyinUtils.getAllPinyin("\u897f\u74dc", false));
    }
}

