/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.WardenSoulStackType;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import java.util.List;

public class WardenSoulStackTypedHandler
implements ISoulHandler {
    private StackTypedHandler handlerStorage;

    public WardenSoulStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getSoulTanks() {
        return this.handlerStorage.getTypeIdIndexList(WardenSoulStackType.ID).map(List::size).orElse(0);
    }

    public int getSoulInTank(int slot) {
        return this.handlerStorage.getTypeIdIndexList(WardenSoulStackType.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> (Integer)slots.get(slot)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> BDMath.clampLongToInt(stack.getStackAmount())).orElse(0);
    }

    public int getTankCapacity(int slot) {
        return BDMath.clampLongToInt(this.handlerStorage.getSlotCapacity(slot));
    }

    public int fill(int amount, ISoulHandler.Action action) {
        return (int)((long)amount - this.handlerStorage.insert(new WardenSoulStackType(amount), action.simulate()).getStackAmount());
    }

    public int drain(int amount, ISoulHandler.Action action) {
        return (int)this.handlerStorage.extract(new WardenSoulStackType(amount), action.simulate()).getStackAmount();
    }
}

