/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.RegistryUtil;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientTooltipFlag;

public final class ItemStackType
implements IStackType<ItemStack> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/item");
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private static final MapCodec<ItemStackType> NEW_FMT = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(t -> RegistryUtil.holderOf(t.item)), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(t -> t.patch), (App)Codec.LONG.fieldOf("amount").forGetter(ItemStackType::getStackAmount)).apply((Applicative)instance, (holder, patch, amount) -> new ItemStackType((Item)holder.value(), (DataComponentPatch)patch, (long)amount)));
    private static final Codec<ItemStackType> LEGACY_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("internal_stack").forGetter(ItemStackType::getStack), (App)Codec.LONG.fieldOf("amount").forGetter(ItemStackType::getStackAmount)).apply((Applicative)inst, (stack, amt) -> new ItemStackType((ItemStack)stack, (long)amt)));
    public static final MapCodec<ItemStackType> TYPE_CODEC = new MapCodec<ItemStackType>(){

        public <T> DataResult<ItemStackType> decode(DynamicOps<T> ops, MapLike<T> input) {
            Object kItem = ops.createString("item");
            Object kAmount = ops.createString("amount");
            Object kLegacy = ops.createString("internal_stack");
            Object kComps = ops.createString("components");
            Object hasItem = input.get(kItem);
            Object hasAmount = input.get(kAmount);
            if (hasItem != null && hasAmount != null) {
                DataResult r = NEW_FMT.decode(ops, input);
                if (r.result().isPresent()) {
                    return r;
                }
                long amt = Codec.LONG.parse(ops, hasAmount).result().orElse(0L);
                DataComponentPatch patch = DataComponentPatch.EMPTY;
                Object compsNode = input.get(kComps);
                if (compsNode != null) {
                    patch = DataComponentPatch.CODEC.parse(ops, compsNode).result().orElse(DataComponentPatch.EMPTY);
                }
                return DataResult.success((Object)new ItemStackType(Items.AIR, patch, amt));
            }
            Object hasLegacy = input.get(kLegacy);
            if (hasLegacy != null && hasAmount != null) {
                LinkedHashMap map = new LinkedHashMap();
                input.entries().forEach(p -> map.put(p.getFirst(), p.getSecond()));
                Object node = ops.createMap(map);
                return LEGACY_CODEC.decode(ops, node).map(Pair::getFirst);
            }
            return NEW_FMT.decode(ops, input);
        }

        public <T> RecordBuilder<T> encode(ItemStackType value, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return NEW_FMT.encode((Object)value, ops, prefix);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of("item", "components", "amount").map(arg_0 -> ops.createString(arg_0));
        }
    };
    public static final Codec<ItemStackType> CODEC = TYPE_CODEC.codec();
    private Item item;
    private DataComponentPatch patch;
    private long stackSize;
    private ItemStack serverCache;
    private ItemStack clientCache;
    private int vanillaStackSize = -1;
    private int hashCodeCache = 0;
    private boolean NeedRecalHash = true;

    public ItemStackType() {
        this.item = Items.AIR;
        this.patch = DataComponentPatch.EMPTY;
        this.stackSize = 0L;
        this.serverCache = ItemStack.EMPTY;
        this.clientCache = ItemStack.EMPTY;
    }

    public ItemStackType(ItemStack stack) {
        this.item = stack.getItem();
        this.patch = stack.getComponentsPatch();
        this.stackSize = stack.getCount();
        this.serverCache = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        this.clientCache = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
    }

    public ItemStackType(ItemStack stack, long stackSize) {
        this.item = stack.getItem();
        this.patch = stack.getComponentsPatch();
        this.stackSize = stackSize;
        this.serverCache = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        this.clientCache = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
    }

    private ItemStackType(Item item, DataComponentPatch patch, long stackSize) {
        this.item = item;
        this.patch = patch == null ? DataComponentPatch.EMPTY : patch;
        this.stackSize = stackSize;
        this.serverCache = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        this.clientCache = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
    }

    @Override
    public MapCodec<ItemStackType> codec() {
        return TYPE_CODEC;
    }

    @Override
    public IStackType<ItemStack> fromObject(Object key, long amount, DataComponentPatch dataComponentPatch) {
        if (key instanceof Item) {
            Item it = (Item)key;
            DataComponentPatch p = dataComponentPatch != null && !dataComponentPatch.isEmpty() ? PatchedDataComponentMap.fromPatch((DataComponentMap)it.components(), (DataComponentPatch)dataComponentPatch).asPatch() : DataComponentPatch.EMPTY;
            return new ItemStackType(it, p, amount);
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        if (this.serverCache.isEmpty() || this.serverCache.getItem() != this.item) {
            this.serverCache = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
            this.NeedRecalHash = true;
        }
        this.serverCache.setCount(BDMath.clampLongToInt(this.stackSize));
        return this.serverCache;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.item = stack.getItem();
        this.patch = stack.getComponentsPatch();
        this.stackSize = stack.getCount();
        this.serverCache = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        this.clientCache = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        this.NeedRecalHash = true;
        this.vanillaStackSize = -1;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<ItemStack> getEmpty() {
        return new ItemStackType();
    }

    @Override
    public Class<ItemStack> getStackClass() {
        return ItemStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Item.class;
    }

    @Override
    public Object getSource() {
        return Items.AIR;
    }

    @Override
    public String getModId() {
        return BuiltInRegistries.ITEM.getKey((Object)this.item).getNamespace();
    }

    @Override
    public boolean isEmpty() {
        return this.item == Items.AIR || this.stackSize <= 0L;
    }

    @Override
    public boolean isEmptyStack() {
        return this.item == Items.AIR;
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack copyStack() {
        ItemStack base = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        return base.copyWithCount(BDMath.clampLongToInt(this.stackSize));
    }

    @Override
    public ItemStack copyStackWithCount(long count) {
        ItemStack base = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        return base.copyWithCount(BDMath.clampLongToInt(count));
    }

    @Override
    public IStackType<ItemStack> copy() {
        ItemStackType cp = new ItemStackType(this.item, this.patch, this.stackSize);
        cp.NeedRecalHash = this.NeedRecalHash;
        cp.hashCodeCache = this.hashCodeCache;
        return cp;
    }

    @Override
    public IStackType<ItemStack> copyWithCount(long count) {
        ItemStackType cp = new ItemStackType(this.item, this.patch, count);
        cp.NeedRecalHash = this.NeedRecalHash;
        cp.hashCodeCache = this.hashCodeCache;
        return cp;
    }

    @Override
    public long getStackAmount() {
        return this.stackSize;
    }

    @Override
    public void setStackAmount(long amount) {
        this.stackSize = amount;
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        if (this.item == Items.AIR) {
            return 0L;
        }
        if (this.vanillaStackSize <= 0) {
            if (this.serverCache.isEmpty() || this.serverCache.getItem() != this.item) {
                this.serverCache = new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
            }
            this.vanillaStackSize = this.serverCache.getMaxStackSize();
        }
        return Math.min((long)this.vanillaStackSize, this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public ItemStack splitStack(long amount) {
        if (amount <= 0L || this.item == Items.AIR) {
            return ItemStack.EMPTY;
        }
        int splitAmount = BDMath.clampLongToInt(Math.min(amount, this.stackSize));
        this.shrink(splitAmount);
        return new ItemStack(RegistryUtil.holderOf(this.item), splitAmount, this.patch);
    }

    @Override
    public IStackType<ItemStack> split(long amount) {
        if (amount <= 0L || this.item == Items.AIR) {
            return new ItemStackType();
        }
        long splitAmount = Math.min(amount, this.stackSize);
        this.shrink(splitAmount);
        return new ItemStackType(this.item, this.patch, splitAmount);
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        if (tagKey == null || this.item == Items.AIR) {
            return false;
        }
        if (!tagKey.isFor(Registries.ITEM)) {
            return false;
        }
        TagKey<?> itemTag = tagKey;
        return RegistryUtil.holderOf(this.item).is(itemTag);
    }

    @Override
    public boolean isSame(IStackType<?> other) {
        if (other instanceof ItemStackType) {
            ItemStackType otherItemStackType = (ItemStackType)other;
            return this.item == otherItemStackType.item;
        }
        return false;
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<?> other) {
        if (other instanceof ItemStackType) {
            ItemStackType otherItemStackType = (ItemStackType)other;
            return this.item == otherItemStackType.item && Objects.equals(this.patch, otherItemStackType.patch);
        }
        return false;
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getTypeId());
        boolean hasItem = this.item != Items.AIR;
        buf.writeBoolean(hasItem);
        if (!hasItem) {
            return;
        }
        buf.writeVarLong(this.stackSize);
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)this.item);
        buf.writeResourceLocation(key);
        DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)this.patch);
    }

    public ItemStackType deserialize(RegistryFriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ItemStackType(ItemStack.EMPTY);
        }
        long amount = buf.readVarLong();
        ResourceLocation key = buf.readResourceLocation();
        Item it = (Item)BuiltInRegistries.ITEM.get(key);
        DataComponentPatch patch = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
        return new ItemStackType(it, patch, amount);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag out = new CompoundTag();
        try {
            out.putString("Type", ID.toString());
            RegistryOps ops = levelRegistryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            CODEC.encodeStart((DynamicOps)ops, (Object)this).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("ItemStackType \u5728\u5e8f\u5217\u5316(Codec)\u65f6\u51fa\u9519: {}", err)).ifPresent(nbt -> {
                if (nbt instanceof CompoundTag) {
                    CompoundTag ct = (CompoundTag)nbt;
                    out.merge(ct);
                } else {
                    out.put("value", nbt);
                }
            });
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.error("ItemStackType \u5728\u5e8f\u5217\u5316\u65f6\u51fa\u9519: {}", (Object)t.getMessage(), (Object)t);
        }
        return out;
    }

    public ItemStackType deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        try {
            Optional valDecoded;
            RegistryOps ops = levelRegistryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            Optional decoded = CODEC.parse((DynamicOps)ops, (Object)nbt).result();
            if (decoded.isPresent()) {
                return (ItemStackType)decoded.get();
            }
            if (nbt.contains("value", 10) && (valDecoded = CODEC.parse((DynamicOps)ops, (Object)nbt.getCompound("value")).result()).isPresent()) {
                return (ItemStackType)valDecoded.get();
            }
            if (nbt.contains("Item", 8)) {
                Item it;
                ResourceLocation key = ResourceLocation.tryParse((String)nbt.getString("Item"));
                Item item = it = key != null ? (Item)BuiltInRegistries.ITEM.get(key) : null;
                if (it == null) {
                    BeyondDimensions.LOGGER.warn("ItemStackType \u53cd\u5e8f\u5217\u5316\u65e7\u683c\u5f0f\u65f6\u672a\u627e\u5230\u7269\u54c1: '{}', \u56de\u9000 AIR", (Object)nbt.getString("Item"));
                    it = Items.AIR;
                }
                long amount = nbt.getLong("Amount");
                DataComponentPatch p = DataComponentPatch.EMPTY;
                if (nbt.contains("Components")) {
                    p = DataComponentPatch.CODEC.parse((DynamicOps)ops, (Object)nbt.get("Components")).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("ItemStackType \u53cd\u5e8f\u5217\u5316\u65e7\u7ec4\u4ef6\u65f6\u51fa\u9519: {}", err)).orElse(DataComponentPatch.EMPTY);
                }
                return new ItemStackType(it, p, amount);
            }
            if (nbt.contains("Stack", 10)) {
                ItemStack s = ItemStack.parseOptional((HolderLookup.Provider)levelRegistryAccess, (CompoundTag)nbt.getCompound("Stack"));
                long amount = nbt.getLong("Amount");
                return new ItemStackType(s, amount);
            }
            BeyondDimensions.LOGGER.warn("ItemStackType \u53cd\u5e8f\u5217\u5316\u65f6\uff1a\u65b0\u65e7\u683c\u5f0f\u5747\u4e0d\u5339\u914d\uff0c\u8fd4\u56de\u7a7a\u5b9e\u73b0\u3002Keys={}", (Object)nbt.getAllKeys());
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.error("ItemStackType \u53cd\u5e8f\u5217\u5316\u51fa\u73b0\u9519\u8bef\u3002Keys={} Error={}", new Object[]{nbt.getAllKeys(), t.getMessage(), t});
        }
        return new ItemStackType();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        if (this.clientCache.isEmpty() || this.clientCache.getItem() != this.item) {
            this.clientCache = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        }
        this.clientCache.setCount(1);
        gui.renderFakeItem(this.clientCache, x, y);
        gui.renderItemDecorations(Minecraft.getInstance().font, this.clientCache, x, y, "");
        poseStack.popPose();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!this.clientCache.isEmpty()) {
            gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.popPose();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName() {
        if (this.clientCache.isEmpty() || this.clientCache.getItem() != this.item) {
            this.clientCache = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        }
        return this.clientCache.getDisplayName();
    }

    @Override
    public List<Component> getTooltipLines(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (this.clientCache.isEmpty() || this.clientCache.getItem() != this.item) {
            this.clientCache = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        }
        List tooltips = this.clientCache.getTooltipLines(tooltipContext, player, tooltipFlag);
        tooltips.add(Component.translatable((String)"istack.beyonddimensions.storage_num.item", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        if (this.clientCache.isEmpty() || this.clientCache.getItem() != this.item) {
            this.clientCache = this.item == Items.AIR ? ItemStack.EMPTY : new ItemStack(RegistryUtil.holderOf(this.item), 1, this.patch);
        }
        return this.clientCache.getTooltipImage();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        Item.TooltipContext ctx = minecraft.level != null ? Item.TooltipContext.of((Level)minecraft.level) : Item.TooltipContext.EMPTY;
        gui.renderTooltip(minecraft.font, this.getTooltipLines(ctx, (Player)minecraft.player, ClientTooltipFlag.of((TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))), this.getTooltipImage(), ItemStack.EMPTY, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof ItemStackType) {
            ItemStackType otherStack = (ItemStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.NeedRecalHash) {
            int i = 31 + this.item.hashCode();
            this.hashCodeCache = 31 * i + this.patch.hashCode();
            this.NeedRecalHash = false;
        }
        return this.hashCodeCache;
    }
}

