/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ChemicalStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.resources.ResourceLocation;

public class ChemicalHandlerWrapper
implements IStackHandlerWrapper<ChemicalStack> {
    private final IChemicalHandler chemicalHandler;

    public ChemicalHandlerWrapper(Object chemicalHandler) {
        this.chemicalHandler = (IChemicalHandler)chemicalHandler;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ChemicalStackType.ID;
    }

    @Override
    public int getSlots() {
        return this.chemicalHandler.getChemicalTanks();
    }

    @Override
    public ChemicalStack getStackInSlot(int slot) {
        return this.chemicalHandler.getChemicalInTank(slot);
    }

    @Override
    public long getCapacity(int slot) {
        return this.chemicalHandler.getChemicalTankCapacity(slot);
    }

    @Override
    public boolean isStackValid(int slot, ChemicalStack stack) {
        return this.chemicalHandler.isValid(slot, stack);
    }

    @Override
    public long insert(int slot, ChemicalStack Stack, boolean sim) {
        if (sim) {
            return this.chemicalHandler.insertChemical(slot, Stack, Action.SIMULATE).getAmount();
        }
        return this.chemicalHandler.insertChemical(slot, Stack, Action.EXECUTE).getAmount();
    }

    @Override
    public long insert(ChemicalStack stack, boolean sim) {
        if (sim) {
            return this.chemicalHandler.insertChemical(stack, Action.SIMULATE).getAmount();
        }
        return this.chemicalHandler.insertChemical(stack, Action.EXECUTE).getAmount();
    }

    @Override
    public long extract(int slot, long amount, boolean sim) {
        if (sim) {
            return this.chemicalHandler.extractChemical(slot, amount, Action.SIMULATE).getAmount();
        }
        return this.chemicalHandler.extractChemical(slot, amount, Action.EXECUTE).getAmount();
    }

    @Override
    public long extract(ChemicalStack stack, boolean sim) {
        if (sim) {
            return this.chemicalHandler.extractChemical(stack, Action.SIMULATE).getAmount();
        }
        return this.chemicalHandler.extractChemical(stack, Action.EXECUTE).getAmount();
    }
}

