/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.WardenSoulStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Unit.BDMath;

public class WardenSoulUnifiedStorageHandler
implements ISoulHandler {
    private UnifiedStorage storage;

    public WardenSoulUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getSoulTanks() {
        return this.storage.getTypeIdIndexList(WardenSoulStackType.ID).map(list -> this.storage.isFullSlotsSize() ? list.size() : list.size() + 1).orElse(this.storage.isFullSlotsSize() ? 0 : 1);
    }

    public int getSoulInTank(int slot) {
        return this.storage.getTypeIdIndexList(WardenSoulStackType.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> (Integer)slots.get(slot)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (WardenSoulStackType)this.storage.getStackBySlot((int)actualIndex)).map(stack -> BDMath.clampLongToInt(stack.getStackAmount())).orElse(0);
    }

    public int getTankCapacity(int slot) {
        return BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
    }

    public int fill(int amount, ISoulHandler.Action action) {
        return (int)((long)amount - this.storage.insert(new WardenSoulStackType(amount), action.simulate()).getStackAmount());
    }

    public int drain(int amount, ISoulHandler.Action action) {
        return (int)this.storage.extract(new WardenSoulStackType(amount), action.simulate()).getStackAmount();
    }
}

