/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.EMI.Recipe;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetRecipeHandler<T extends DimensionsCraftMenu>
implements StandardRecipeHandler<T> {
    public List<Slot> getInputSources(T handler) {
        ArrayList<Slot> inputSlots = new ArrayList<Slot>();
        for (Slot slot : ((DimensionsCraftMenu)((Object)handler)).slots) {
            if (slot instanceof ResultSlot || slot instanceof AbstractStackTypedSlot) continue;
            inputSlots.add(slot);
        }
        return inputSlots;
    }

    public List<Slot> getCraftingSlots(T handler) {
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (int i = ((DimensionsCraftMenu)((Object)handler)).craftSlotStartIndex; i < ((DimensionsCraftMenu)((Object)handler)).craftSlotEndIndex; ++i) {
            craftingSlots.add((Slot)((DimensionsCraftMenu)((Object)handler)).slots.get(i));
        }
        return craftingSlots;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<T> screen) {
        List stacks = this.getInputSources((T)((Object)((DimensionsCraftMenu)screen.getMenu()))).stream().map(Slot::getItem).map(EmiStack::of).collect(Collectors.toCollection(ArrayList::new));
        if (((DimensionsCraftMenu)screen.getMenu()).storage.getStorage() != null) {
            for (IStackType stackType : ((DimensionsCraftMenu)screen.getMenu()).storage.getStorage()) {
                ItemStackType itemStackType;
                if (!(stackType instanceof ItemStackType) || (itemStackType = (ItemStackType)stackType).isEmpty()) continue;
                stacks.add(EmiStack.of((ItemStack)itemStackType.getStack()));
            }
        }
        return new EmiPlayerInventory(stacks);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        Minecraft.getInstance().setScreen((Screen)context.getScreen());
        List inputs = recipe.getInputs();
        ArrayList<ItemStack> inputElements = new ArrayList<ItemStack>();
        DimensionsCraftMenu menu = (DimensionsCraftMenu)context.getScreen().getMenu();
        List<Slot> craftingSlots = this.getInputSources((T)((Object)menu));
        List<IStackType> storageSlots = menu.storage.getStorage();
        ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
        for (Slot slot : craftingSlots) {
            if (!slot.hasItem()) continue;
            availableItems.add(slot.getItem());
        }
        for (IStackType stackType : storageSlots) {
            ItemStackType itemStackType;
            ItemStack stack;
            if (!(stackType instanceof ItemStackType) || (stack = (itemStackType = (ItemStackType)stackType).getStack()).isEmpty()) continue;
            availableItems.add(stack);
        }
        for (ItemStack itemStack : menu.player.getInventory().items) {
            if (itemStack.isEmpty()) continue;
            availableItems.add(itemStack);
        }
        block3: for (EmiIngredient ingredient : inputs) {
            if (ingredient.isEmpty()) {
                inputElements.add(ItemStack.EMPTY);
                continue;
            }
            ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
            for (ItemStack stack : availableItems) {
                if (stack.isEmpty() || !ingredient.getEmiStacks().stream().anyMatch(emiStack -> emiStack.getItemStack().getItem() == stack.getItem())) continue;
                matching.add(stack.copy());
            }
            int required = (int)ingredient.getAmount();
            int available = matching.stream().mapToInt(ItemStack::getCount).sum();
            if (available >= required) {
                ItemStack merged = matching.isEmpty() ? ItemStack.EMPTY : ((ItemStack)matching.get(0)).copyWithCount(required);
                inputElements.add(merged);
                int remaining = required;
                for (ItemStack stack : matching) {
                    int deduct = Math.min(remaining, stack.getCount());
                    stack.shrink(deduct);
                    if ((remaining -= deduct) > 0) continue;
                    continue block3;
                }
                continue;
            }
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"beyonddimensions.message.insufficient_materials"), true);
            return true;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new RecipeFillC2SPacket(inputElements), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }
}

