/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class NetedItem
extends Item {
    public static final Logger LOGGER = LogUtils.getLogger();

    public NetedItem(Item.Properties properties) {
        super(properties.component(ModDataComponents.NET_ID_DATA, (Object)-1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || !player.isShiftKeyDown()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (level.isClientSide()) return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
        if (net == null) return InteractionResultHolder.fail((Object)itemstack);
        if (this.validToReWrite(net, player)) {
            if (((Integer)itemstack.get(ModDataComponents.NET_ID_DATA)).intValue() != net.getId()) {
                itemstack.set(ModDataComponents.NET_ID_DATA, (Object)net.getId());
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.8f, 1.0f);
                player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.item_net_bound", (Object[])new Object[]{net.getId()}));
                return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
            } else {
                itemstack.set(ModDataComponents.NET_ID_DATA, (Object)-1);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.8f, 1.0f);
                player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.item_net_unbound", (Object[])new Object[]{net.getId()}));
            }
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.no_right_to_bound_item"));
            return InteractionResultHolder.fail((Object)itemstack);
        }
    }

    public static DimensionsNet getNet(ItemStack stack, MinecraftServer dataProvider) {
        int netId = (Integer)stack.getOrDefault(ModDataComponents.NET_ID_DATA, (Object)-1);
        if (netId >= 0) {
            return DimensionsNet.getNetFromId(netId, dataProvider);
        }
        return null;
    }

    protected boolean validToReWrite(DimensionsNet net, Player player) {
        return net.isManager(player);
    }
}

