/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.ShortCutKey;

import com.mojang.blaze3d.platform.InputConstants;
import com.wintercogs.beyonddimensions.Api.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.GUI.NetMenuType;
import com.wintercogs.beyonddimensions.Packet.OpenNetGuiPacket;
import com.wintercogs.beyonddimensions.Packet.ToggleMagnetPacket;
import com.wintercogs.beyonddimensions.Registry.ShortCutKeyRegister;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="beyonddimensions", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class DimensionsShortKeys {
    public static final KeyMapping OPEN_GUI_KEY = new KeyMapping("key.beyonddimensions.open_gui", 79, "key.categories.beyonddimensions");
    public static final KeyMapping OPEN_TERMINAL_QUICK_KEY = new KeyMapping("key.beyonddimensions.open_terminal_quick_key", 80, "key.categories.beyonddimensions");
    public static final KeyMapping MAIN_HAND_ITEM_TRANSFER_KEY = new KeyMapping("key.beyonddimensions.main_hand_item_transfer_key", InputConstants.Type.MOUSE, 2, "key.categories.beyonddimensions");
    public static final KeyMapping TOGGLE_MAGNET_KEY = new KeyMapping("key.beyonddimensions.toggle_magnet_key", 80, "key.categories.beyonddimensions");

    public static void register() {
        ShortCutKeyRegister.registerKey(OPEN_GUI_KEY);
        ShortCutKeyRegister.registerKey(OPEN_TERMINAL_QUICK_KEY);
        ShortCutKeyRegister.registerKey(MAIN_HAND_ITEM_TRANSFER_KEY);
        ShortCutKeyRegister.registerKey(TOGGLE_MAGNET_KEY);
    }

    @SubscribeEvent
    public static void onKeyInput(ClientTickEvent.Post event) {
        LocalPlayer player;
        while (OPEN_GUI_KEY.consumeClick()) {
            player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            if (Config.uiCraftButton == ButtonState.ENABLED) {
                PacketDistributor.sendToServer((CustomPacketPayload)new OpenNetGuiPacket(player.getStringUUID(), NetMenuType.NET_CRAFT_MENU), (CustomPacketPayload[])new CustomPacketPayload[0]);
                continue;
            }
            if (Config.uiCraftButton != ButtonState.DISABLED) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenNetGuiPacket(player.getStringUUID(), NetMenuType.NET_MENU), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        while (OPEN_TERMINAL_QUICK_KEY.consumeClick()) {
            player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenNetGuiPacket(player.getStringUUID(), NetMenuType.NET_CRAFT_TERMINAL), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        while (TOGGLE_MAGNET_KEY.consumeClick()) {
            player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ToggleMagnetPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

