/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.GasStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import mekanism.api.Action;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import org.jetbrains.annotations.NotNull;

public class GasStackTypedHandler
implements IGasHandler {
    private final StackTypedHandler handlerStorage;

    public GasStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getSlots();
    }

    @NotNull
    public GasStack getChemicalInTank(int tank) {
        GasStackType gasStack;
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return GasStack.EMPTY;
        }
        IStackType<?> stack = this.handlerStorage.getStackBySlot(tank);
        if (stack instanceof GasStackType && !(gasStack = (GasStackType)stack).isEmpty()) {
            return gasStack.copyStack();
        }
        return GasStack.EMPTY;
    }

    public void setChemicalInTank(int tank, @NotNull GasStack stack) {
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return;
        }
        if (stack.isEmpty()) {
            this.handlerStorage.setStackDirectly(tank, new ItemStackType());
        } else {
            this.handlerStorage.setStackDirectly(tank, new GasStackType(stack.copy()));
        }
    }

    public long getTankCapacity(int tank) {
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return 0L;
        }
        return 64000L;
    }

    public boolean isValid(int tank, @NotNull GasStack stack) {
        return true;
    }

    @NotNull
    public GasStack insertChemical(int tank, GasStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return GasStack.EMPTY;
        }
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return stack.copy();
        }
        if (!this.isValid(tank, stack)) {
            return stack.copy();
        }
        IStackType<?> remainingStack = this.handlerStorage.insert(tank, new GasStackType(stack.copy()), action.simulate());
        long remaining = remainingStack.getStackAmount();
        if (remaining <= 0L) {
            return GasStack.EMPTY;
        }
        return new GasStack(stack, remaining);
    }

    @NotNull
    public GasStack extractChemical(int tank, long amount, @NotNull Action action) {
        GasStackType gasExtract;
        if (tank < 0 || tank >= this.handlerStorage.getSlots() || amount <= 0L) {
            return GasStack.EMPTY;
        }
        IStackType<?> current = this.handlerStorage.getStackBySlot(tank);
        if (!(current instanceof GasStackType) || current.isEmpty()) {
            return GasStack.EMPTY;
        }
        IStackType<?> extracted = this.handlerStorage.extract(tank, amount, action.simulate());
        if (extracted instanceof GasStackType && !(gasExtract = (GasStackType)extracted).isEmpty()) {
            return gasExtract.copyStack();
        }
        return GasStack.EMPTY;
    }

    @NotNull
    public GasStack insertChemical(GasStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return GasStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new GasStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new GasStack(stack, remaining);
        }
        return GasStack.EMPTY;
    }

    @NotNull
    public GasStack extractChemical(long amount, @NotNull Action action) {
        if (amount <= 0L) {
            return GasStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(GasStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> this.handlerStorage.extract((int)actualIndex, amount, action.simulate())).map(extracts -> ((GasStackType)extracts).copyStack()).orElse(GasStack.EMPTY);
    }

    @NotNull
    public GasStack extractChemical(GasStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return GasStack.EMPTY;
        }
        return ((GasStackType)this.handlerStorage.extract(new GasStackType(stack.copy()), action.simulate())).copyStack();
    }

    @NotNull
    public GasStack getEmptyStack() {
        return GasStack.EMPTY;
    }
}

