/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.InfusionStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import mekanism.api.Action;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import org.jetbrains.annotations.NotNull;

public class InfusionStackTypedHandler
implements IInfusionHandler {
    private final StackTypedHandler handlerStorage;

    public InfusionStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getSlots();
    }

    @NotNull
    public InfusionStack getChemicalInTank(int tank) {
        InfusionStackType infusionStack;
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return InfusionStack.EMPTY;
        }
        IStackType<?> stack = this.handlerStorage.getStackBySlot(tank);
        if (stack instanceof InfusionStackType && !(infusionStack = (InfusionStackType)stack).isEmpty()) {
            return infusionStack.copyStack();
        }
        return InfusionStack.EMPTY;
    }

    public void setChemicalInTank(int tank, @NotNull InfusionStack stack) {
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return;
        }
        if (stack.isEmpty()) {
            this.handlerStorage.setStackDirectly(tank, new ItemStackType());
        } else {
            this.handlerStorage.setStackDirectly(tank, new InfusionStackType(stack.copy()));
        }
    }

    public long getTankCapacity(int tank) {
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return 0L;
        }
        return 64000L;
    }

    public boolean isValid(int tank, @NotNull InfusionStack stack) {
        return true;
    }

    @NotNull
    public InfusionStack insertChemical(int tank, InfusionStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return InfusionStack.EMPTY;
        }
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return stack.copy();
        }
        if (!this.isValid(tank, stack)) {
            return stack.copy();
        }
        IStackType<?> remainingStack = this.handlerStorage.insert(tank, new InfusionStackType(stack.copy()), action.simulate());
        long remaining = remainingStack.getStackAmount();
        if (remaining <= 0L) {
            return InfusionStack.EMPTY;
        }
        return new InfusionStack(stack, remaining);
    }

    @NotNull
    public InfusionStack extractChemical(int tank, long amount, @NotNull Action action) {
        InfusionStackType infusionExtract;
        if (tank < 0 || tank >= this.handlerStorage.getSlots() || amount <= 0L) {
            return InfusionStack.EMPTY;
        }
        IStackType<?> current = this.handlerStorage.getStackBySlot(tank);
        if (!(current instanceof InfusionStackType) || current.isEmpty()) {
            return InfusionStack.EMPTY;
        }
        IStackType<?> extracted = this.handlerStorage.extract(tank, amount, action.simulate());
        if (extracted instanceof InfusionStackType && !(infusionExtract = (InfusionStackType)extracted).isEmpty()) {
            return infusionExtract.copyStack();
        }
        return InfusionStack.EMPTY;
    }

    @NotNull
    public InfusionStack insertChemical(InfusionStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return InfusionStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new InfusionStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new InfusionStack(stack, remaining);
        }
        return InfusionStack.EMPTY;
    }

    @NotNull
    public InfusionStack extractChemical(long amount, @NotNull Action action) {
        if (amount <= 0L) {
            return InfusionStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(InfusionStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> this.handlerStorage.extract((int)actualIndex, amount, action.simulate())).map(extracts -> ((InfusionStackType)extracts).copyStack()).orElse(InfusionStack.EMPTY);
    }

    @NotNull
    public InfusionStack extractChemical(InfusionStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return InfusionStack.EMPTY;
        }
        return ((InfusionStackType)this.handlerStorage.extract(new InfusionStackType(stack.copy()), action.simulate())).copyStack();
    }

    @NotNull
    public InfusionStack getEmptyStack() {
        return InfusionStack.EMPTY;
    }
}

