/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.PigmentStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import mekanism.api.Action;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import org.jetbrains.annotations.NotNull;

public class PigmentStackTypedHandler
implements IPigmentHandler {
    private final StackTypedHandler handlerStorage;

    public PigmentStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getSlots();
    }

    @NotNull
    public PigmentStack getChemicalInTank(int tank) {
        PigmentStackType pigmentStack;
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return PigmentStack.EMPTY;
        }
        IStackType<?> stack = this.handlerStorage.getStackBySlot(tank);
        if (stack instanceof PigmentStackType && !(pigmentStack = (PigmentStackType)stack).isEmpty()) {
            return pigmentStack.copyStack();
        }
        return PigmentStack.EMPTY;
    }

    public void setChemicalInTank(int tank, @NotNull PigmentStack stack) {
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return;
        }
        if (stack.isEmpty()) {
            this.handlerStorage.setStackDirectly(tank, new ItemStackType());
        } else {
            this.handlerStorage.setStackDirectly(tank, new PigmentStackType(stack.copy()));
        }
    }

    public long getTankCapacity(int tank) {
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return 0L;
        }
        return 64000L;
    }

    public boolean isValid(int tank, @NotNull PigmentStack stack) {
        return true;
    }

    @NotNull
    public PigmentStack insertChemical(int tank, PigmentStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return PigmentStack.EMPTY;
        }
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return stack.copy();
        }
        if (!this.isValid(tank, stack)) {
            return stack.copy();
        }
        IStackType<?> remainingStack = this.handlerStorage.insert(tank, new PigmentStackType(stack.copy()), action.simulate());
        long remaining = remainingStack.getStackAmount();
        if (remaining <= 0L) {
            return PigmentStack.EMPTY;
        }
        return new PigmentStack(stack, remaining);
    }

    @NotNull
    public PigmentStack extractChemical(int tank, long amount, @NotNull Action action) {
        PigmentStackType pigmentExtract;
        if (tank < 0 || tank >= this.handlerStorage.getSlots() || amount <= 0L) {
            return PigmentStack.EMPTY;
        }
        IStackType<?> current = this.handlerStorage.getStackBySlot(tank);
        if (!(current instanceof PigmentStackType) || current.isEmpty()) {
            return PigmentStack.EMPTY;
        }
        IStackType<?> extracted = this.handlerStorage.extract(tank, amount, action.simulate());
        if (extracted instanceof PigmentStackType && !(pigmentExtract = (PigmentStackType)extracted).isEmpty()) {
            return pigmentExtract.copyStack();
        }
        return PigmentStack.EMPTY;
    }

    @NotNull
    public PigmentStack insertChemical(PigmentStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return PigmentStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new PigmentStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new PigmentStack(stack, remaining);
        }
        return PigmentStack.EMPTY;
    }

    @NotNull
    public PigmentStack extractChemical(long amount, @NotNull Action action) {
        if (amount <= 0L) {
            return PigmentStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(PigmentStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> this.handlerStorage.extract((int)actualIndex, amount, action.simulate())).map(extracts -> ((PigmentStackType)extracts).copyStack()).orElse(PigmentStack.EMPTY);
    }

    @NotNull
    public PigmentStack extractChemical(PigmentStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return PigmentStack.EMPTY;
        }
        return ((PigmentStackType)this.handlerStorage.extract(new PigmentStackType(stack.copy()), action.simulate())).copyStack();
    }

    @NotNull
    public PigmentStack getEmptyStack() {
        return PigmentStack.EMPTY;
    }
}

