/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler.Chemicals;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.Chemicals.SlurryStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import mekanism.api.Action;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import org.jetbrains.annotations.NotNull;

public class SlurryStackTypedHandler
implements ISlurryHandler {
    private final StackTypedHandler handlerStorage;

    public SlurryStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getSlots();
    }

    @NotNull
    public SlurryStack getChemicalInTank(int tank) {
        SlurryStackType slurryStack;
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return SlurryStack.EMPTY;
        }
        IStackType<?> stack = this.handlerStorage.getStackBySlot(tank);
        if (stack instanceof SlurryStackType && !(slurryStack = (SlurryStackType)stack).isEmpty()) {
            return slurryStack.copyStack();
        }
        return SlurryStack.EMPTY;
    }

    public void setChemicalInTank(int tank, @NotNull SlurryStack stack) {
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return;
        }
        if (stack.isEmpty()) {
            this.handlerStorage.setStackDirectly(tank, new ItemStackType());
        } else {
            this.handlerStorage.setStackDirectly(tank, new SlurryStackType(stack.copy()));
        }
    }

    public long getTankCapacity(int tank) {
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return 0L;
        }
        return 64000L;
    }

    public boolean isValid(int tank, @NotNull SlurryStack stack) {
        return true;
    }

    @NotNull
    public SlurryStack insertChemical(int tank, SlurryStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return SlurryStack.EMPTY;
        }
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return stack.copy();
        }
        if (!this.isValid(tank, stack)) {
            return stack.copy();
        }
        IStackType<?> remainingStack = this.handlerStorage.insert(tank, new SlurryStackType(stack.copy()), action.simulate());
        long remaining = remainingStack.getStackAmount();
        if (remaining <= 0L) {
            return SlurryStack.EMPTY;
        }
        return new SlurryStack(stack, remaining);
    }

    @NotNull
    public SlurryStack extractChemical(int tank, long amount, @NotNull Action action) {
        SlurryStackType slurryExtract;
        if (tank < 0 || tank >= this.handlerStorage.getSlots() || amount <= 0L) {
            return SlurryStack.EMPTY;
        }
        IStackType<?> current = this.handlerStorage.getStackBySlot(tank);
        if (!(current instanceof SlurryStackType) || current.isEmpty()) {
            return SlurryStack.EMPTY;
        }
        IStackType<?> extracted = this.handlerStorage.extract(tank, amount, action.simulate());
        if (extracted instanceof SlurryStackType && !(slurryExtract = (SlurryStackType)extracted).isEmpty()) {
            return slurryExtract.copyStack();
        }
        return SlurryStack.EMPTY;
    }

    @NotNull
    public SlurryStack insertChemical(SlurryStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return SlurryStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new SlurryStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new SlurryStack(stack, remaining);
        }
        return SlurryStack.EMPTY;
    }

    @NotNull
    public SlurryStack extractChemical(long amount, @NotNull Action action) {
        if (amount <= 0L) {
            return SlurryStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(SlurryStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> this.handlerStorage.extract((int)actualIndex, amount, action.simulate())).map(extracts -> ((SlurryStackType)extracts).copyStack()).orElse(SlurryStack.EMPTY);
    }

    @NotNull
    public SlurryStack extractChemical(SlurryStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return SlurryStack.EMPTY;
        }
        return ((SlurryStackType)this.handlerStorage.extract(new SlurryStackType(stack.copy()), action.simulate())).copyStack();
    }

    @NotNull
    public SlurryStack getEmptyStack() {
        return SlurryStack.EMPTY;
    }
}

