/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidStackTypedHandler
implements IFluidHandler {
    private final StackTypedHandler handlerStorage;

    public FluidStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getSlots();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        FluidStackType fluidStackType;
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return FluidStack.EMPTY;
        }
        IStackType<?> stack = this.handlerStorage.getStackBySlot(tank);
        if (stack instanceof FluidStackType && !(fluidStackType = (FluidStackType)stack).isEmpty()) {
            return fluidStackType.copyStack();
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        if (tank < 0 || tank >= this.handlerStorage.getSlots()) {
            return 0;
        }
        return 64000;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
        return tank >= 0 && tank < this.handlerStorage.getSlots();
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        int requested = fluidStack.getAmount();
        long remaining = this.handlerStorage.insert(new FluidStackType(fluidStack.copy()), fluidAction.simulate()).getStackAmount();
        int actuallyFilled = requested - (int)remaining;
        return Math.max(actuallyFilled, 0);
    }

    @NotNull
    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        FluidStackType fluidExtract;
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        IStackType<?> extracted = this.handlerStorage.extract(new FluidStackType(fluidStack.copy()), fluidAction.simulate());
        if (extracted instanceof FluidStackType && !(fluidExtract = (FluidStackType)extracted).isEmpty()) {
            return fluidExtract.copyStack();
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int count, IFluidHandler.FluidAction fluidAction) {
        if (count <= 0) {
            return FluidStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(FluidStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> stack.copyWithCount(count)).map(stack -> this.handlerStorage.extract((IStackType<?>)stack, fluidAction.simulate())).map(extracts -> ((FluidStackType)extracts).copyStack()).orElse(FluidStack.EMPTY);
    }
}

