/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ItemStackTypedHandler
implements IItemHandler,
IItemHandlerModifiable {
    private final StackTypedHandler handlerStorage;

    public ItemStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getSlots() {
        return this.handlerStorage.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStackType itemStackType;
        if (slot < 0 || slot >= this.handlerStorage.getSlots()) {
            return ItemStack.f_41583_;
        }
        IStackType<?> stack = this.handlerStorage.getStackBySlot(slot);
        if (stack instanceof ItemStackType && !(itemStackType = (ItemStackType)stack).isEmpty()) {
            return itemStackType.copyStack();
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, ItemStack itemStack, boolean simulate) {
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (slot < 0 || slot >= this.handlerStorage.getSlots()) {
            return itemStack.m_41777_();
        }
        IStackType<?> remainingStack = this.handlerStorage.insert(slot, new ItemStackType(itemStack.m_41777_()), simulate);
        long remaining = remainingStack.getStackAmount();
        if (remaining <= 0L) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)remainingStack.copyStack();
    }

    @NotNull
    public ItemStack extractItem(int slot, int count, boolean simulate) {
        ItemStackType itemExtract;
        if (slot < 0 || slot >= this.handlerStorage.getSlots() || count <= 0) {
            return ItemStack.f_41583_;
        }
        IStackType<?> current = this.handlerStorage.getStackBySlot(slot);
        if (!(current instanceof ItemStackType) || current.isEmpty()) {
            return ItemStack.f_41583_;
        }
        IStackType<?> extracted = this.handlerStorage.extract(slot, count, simulate);
        if (extracted instanceof ItemStackType && !(itemExtract = (ItemStackType)extracted).isEmpty()) {
            return itemExtract.copyStack();
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        if (slot < 0 || slot >= this.handlerStorage.getSlots()) {
            return 0;
        }
        IStackType<?> stack = this.handlerStorage.getStackBySlot(slot);
        if (stack instanceof ItemStackType) {
            ItemStackType itemStackType = (ItemStackType)stack;
            return (int)itemStackType.getVanillaMaxStackSize();
        }
        return 99;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack itemStack) {
        return true;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack itemStack) {
    }
}

