/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.ManaType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.LongStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ManaStackType
extends LongStackType<ManaType> {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"beyonddimensions", (String)"stack_type/mana");
    public static final ManaStackType EMPTY = new ManaStackType();

    public ManaStackType() {
        this.stack = new ManaType(0L);
    }

    public ManaStackType(ManaType stack) {
        this.stack = stack;
    }

    public ManaStackType(long stackSize) {
        this.stack = new ManaType(stackSize);
    }

    @Override
    public ResourceLocation getTypeID() {
        return ID;
    }

    @Override
    public String getModId() {
        return "botania";
    }

    @Override
    public IStackType<ManaType> fromObject(Object key, long amount, CompoundTag dataComponentPatch) {
        if (key instanceof ManaType) {
            return new ManaStackType(amount);
        }
        return null;
    }

    @Override
    public IStackType<ManaType> getEmpty() {
        return new ManaStackType(0L);
    }

    @Override
    public ManaType getSource() {
        return (ManaType)this.stack;
    }

    @Override
    public ManaType getEmptyStack() {
        return new ManaType(0L);
    }

    @Override
    public IStackType<ManaType> copy() {
        ManaStackType copy = new ManaStackType(((ManaType)this.stack).getStackCount());
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<ManaType> copyWithCount(long count) {
        ManaStackType copy = new ManaStackType(count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<ManaType> split(long amount) {
        if (amount <= 0L) {
            return new ManaStackType();
        }
        long splitAmount = Math.min(amount, ((ManaType)this.stack).getStackCount());
        ((ManaType)this.stack).shrink(splitAmount);
        return new ManaStackType(splitAmount);
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        return false;
    }

    @Override
    public long getVanillaMaxStackSize() {
        return 1000000L;
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130085_(this.getTypeId());
        buf.m_130103_(((ManaType)this.stack).getStackCount());
    }

    @Override
    public IStackType<ManaType> deserialize(FriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        long count = buf.m_130258_();
        return new ManaStackType(count);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", ID.toString());
        tag.m_128356_("Amount", this.getStackAmount());
        return tag;
    }

    @Override
    public IStackType<ManaType> deserializeNBT(CompoundTag nbt) {
        return new ManaStackType(nbt.m_128454_("Amount"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        if (((ManaType)this.stack).isEmpty()) {
            return;
        }
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        int tintColor = -1;
        TextureAtlasSprite sprite = IngredientRenderer.BOTANIA_MANA.m_119204_();
        IngredientRenderer.drawTiledSprite(gui, 16, 16, tintColor, 16L, sprite, x, y);
        poseStack.m_85849_();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.m_280168_();
        poseStackText.m_85836_();
        poseStackText.m_252880_(0.0f, 0.0f, 200.0f);
        poseStackText.m_85841_(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92895_(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!((ManaType)this.stack).isEmpty()) {
            gui.m_280488_(Minecraft.m_91087_().f_91062_, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.m_85849_();
    }
}

