/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.Util;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class NbtEq {
    public static boolean equalsRelaxed(@Nullable Tag a, @Nullable Tag b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.m_7060_() != b.m_7060_()) {
            return false;
        }
        switch (a.m_7060_()) {
            case 10: {
                CompoundTag ca = (CompoundTag)a;
                CompoundTag cb = (CompoundTag)b;
                Set ak = ca.m_128431_();
                Set bk = cb.m_128431_();
                if (!ak.equals(bk)) {
                    return false;
                }
                for (String k : ak) {
                    if (NbtEq.equalsRelaxed(ca.m_128423_(k), cb.m_128423_(k))) continue;
                    return false;
                }
                return true;
            }
            case 9: {
                ListTag la = (ListTag)a;
                ListTag lb = (ListTag)b;
                if (la.size() != lb.size() || la.m_7264_() != lb.m_7264_()) {
                    return false;
                }
                for (int i = 0; i < la.size(); ++i) {
                    if (NbtEq.equalsRelaxed(la.get(i), lb.get(i))) continue;
                    return false;
                }
                return true;
            }
            case 6: {
                double x = ((DoubleTag)a).m_7061_();
                double y = ((DoubleTag)b).m_7061_();
                return x == y || Double.isNaN(x) && Double.isNaN(y);
            }
            case 5: {
                float x = ((FloatTag)a).m_7057_();
                float y = ((FloatTag)b).m_7057_();
                return x == y || Float.isNaN(x) && Float.isNaN(y);
            }
        }
        return a.equals(b);
    }

    public static int hashRelaxed(@Nullable Tag t) {
        if (t == null) {
            return 0;
        }
        return switch (t.m_7060_()) {
            case 10 -> {
                CompoundTag c = (CompoundTag)t;
                int sum = 0;
                for (String k : c.m_128431_()) {
                    int kh = k.hashCode();
                    int vh = NbtEq.hashRelaxed(c.m_128423_(k));
                    int eh = kh ^ vh;
                    sum += eh;
                }
                yield NbtEq.avalanche32(sum);
            }
            case 9 -> {
                ListTag l = (ListTag)t;
                int h = 1;
                h = 31 * h + l.m_7264_();
                for (Tag e : l) {
                    h = 31 * h + NbtEq.hashRelaxed(e);
                }
                yield h;
            }
            case 6 -> {
                double v = ((DoubleTag)t).m_7061_();
                if (Double.isNaN(v)) {
                    v = Double.NaN;
                }
                if (v == 0.0) {
                    v = 0.0;
                }
                long bits = Double.doubleToRawLongBits(v);
                yield (int)(bits ^ bits >>> 32);
            }
            case 5 -> {
                float v = ((FloatTag)t).m_7057_();
                if (Float.isNaN(v)) {
                    v = Float.NaN;
                }
                if (v == 0.0f) {
                    v = 0.0f;
                }
                yield Float.floatToRawIntBits(v);
            }
            default -> t.hashCode();
        };
    }

    private static int avalanche32(int x) {
        x ^= x >>> 16;
        x *= 2146121005;
        x ^= x >>> 15;
        x *= -2073254261;
        x ^= x >>> 16;
        return x;
    }
}

