/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.EnergyUnifiedStorageHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class NetEnergyPathwayBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    LazyOptional<IEnergyStorage> opt = LazyOptional.empty();
    private PopMode popMode = PopMode.STOP;
    private final Direction[] directions = Direction.values();

    public NetEnergyPathwayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_ENERGY_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
        this.addNetChangeTask(this::clearCapCache);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            DimensionsNet net = this.getNet();
            if (net == null) {
                return LazyOptional.empty();
            }
            if (!this.opt.isPresent()) {
                this.opt = this.popMode == PopMode.OPEN ? LazyOptional.of(() -> new EnergyStorage(0)) : LazyOptional.of(() -> new EnergyUnifiedStorageHandler(net.getUnifiedStorage()));
            }
            return this.opt.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.clearCapCache();
    }

    public void clearCapCache() {
        if (this.opt.isPresent()) {
            this.opt.invalidate();
        }
        this.opt = LazyOptional.empty();
    }

    public PopMode getPopMode() {
        return this.popMode;
    }

    public void setPopMode(PopMode newMode) {
        if (this.popMode != newMode) {
            this.popMode = newMode;
            this.clearCapCache();
            this.m_6596_();
        }
    }

    @Override
    public boolean shouldWork() {
        return super.shouldWork() && this.getNet() != null;
    }

    @Override
    public int getTicksPerWork() {
        return 1;
    }

    @Override
    public void workContent() {
        super.workContent();
        if (this.popMode == PopMode.OPEN) {
            this.popEnergy();
        }
    }

    private void popEnergy() {
        DimensionsNet net = this.getNet();
        if (net == null) {
            return;
        }
        for (Direction dir : this.directions) {
            LazyOptional otherStorageOptional;
            BlockPos targetPos = this.m_58899_().m_121945_(dir);
            BlockEntity neighbor = this.f_58857_.m_7702_(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity || !(otherStorageOptional = neighbor.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_())).isPresent()) continue;
            IEnergyStorage otherStorage = (IEnergyStorage)otherStorageOptional.resolve().get();
            int maxExtract = (int)Math.min(net.getUnifiedStorage().getEnergyStored(), Integer.MAX_VALUE);
            int receive = otherStorage.receiveEnergy(maxExtract, false);
            net.getUnifiedStorage().extract(new EnergyStackType(receive), false);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        String popModeNew = tag.m_128461_("popMode");
        this.popMode = !popModeNew.isEmpty() ? PopMode.valueOf(popModeNew) : (tag.m_128471_("popMode") ? PopMode.OPEN : PopMode.STOP);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("popMode", this.popMode.name());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"menu.title.beyonddimensions.net_energy_menu");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new NetEnergyMenu(containerId, player.m_150109_(), this);
    }
}

