/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Util.CapCtx;
import com.wintercogs.beyonddimensions.Api.Util.USHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Unit.SidedCapId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class NetPathwayBlockEntity
extends NetedBlockEntity {
    private final Map<SidedCapId, LazyOptional<?>> caps = new HashMap();

    public NetPathwayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
        this.addNetChangeTask(this::clearCapCache);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (Map.Entry<ResourceLocation, Capability<? extends Object>> entry : CapabilityHelper.BlockCapabilityMap.entrySet()) {
                Object result;
                if (entry.getValue() != cap) continue;
                SidedCapId capId = new SidedCapId(cap, null);
                if (this.caps.containsKey(capId) && this.caps.get(capId).isPresent()) {
                    return this.caps.get(capId).cast();
                }
                USHandler handler = CapabilityHelper.USHandlerMap.get(entry.getKey());
                if (handler != null && (result = handler.isContextual() ? handler.apply(net.getUnifiedStorage(), new CapCtx(this.f_58857_, this.m_58899_(), this)) : handler.apply(net.getUnifiedStorage(), null)) != null) {
                    LazyOptional opt = LazyOptional.of(() -> result);
                    this.caps.put(capId, opt);
                    opt.addListener(lo -> this.caps.remove(capId, lo));
                    return opt.cast();
                }
                return LazyOptional.empty();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.clearCapCache();
    }

    private void clearCapCache() {
        ArrayList snapshot = new ArrayList(this.caps.values());
        for (LazyOptional<?> opt : snapshot) {
            try {
                opt.invalidate();
            }
            catch (Throwable throwable) {}
        }
        this.caps.clear();
    }
}

