/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class NetedBlockEntity
extends BlockEntity {
    private int netId = -1;
    private DimensionsNet net = null;
    private List<Runnable> onNetChangeRunnables = new ArrayList<Runnable>();

    public NetedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public int getNetId() {
        return this.netId;
    }

    public void setNetId(int id) {
        boolean needsUpdate = this.netId != id;
        this.netId = id;
        if (this.f_58857_ != null && needsUpdate) {
            this.refreshNetCache();
            this.m_6596_();
        }
    }

    public void clearNetId() {
        boolean needsUpdate = this.netId != -1;
        this.netId = -1;
        this.net = null;
        if (this.f_58857_ != null && needsUpdate) {
            this.m_6596_();
        }
    }

    public void setNetIdFromPlayer(ServerPlayer player) {
        DimensionsNet net = DimensionsNet.getNetFromPlayer((Player)player);
        if (net != null) {
            this.setNetId(net.getId());
        }
    }

    public void setNetIdFromPlayerOrClean(ServerPlayer player) {
        DimensionsNet net = DimensionsNet.getNetFromPlayer((Player)player);
        if (net != null) {
            this.setNetId(net.getId());
        } else {
            this.clearNetId();
        }
    }

    public DimensionsNet getNet() {
        if (this.netId >= 0) {
            if (this.net == null || this.net.deleted) {
                this.refreshNetCache();
            }
            return this.net;
        }
        return null;
    }

    protected void refreshNetCache() {
        if (this.m_58904_() instanceof ServerLevel) {
            DimensionsNet netCache = DimensionsNet.getNetFromId(this.netId, this.m_58904_().m_7654_());
            this.net = netCache != null && !netCache.deleted ? netCache : null;
        }
    }

    public void addNetChangeTask(Runnable runnable) {
        this.onNetChangeRunnables.add(runnable);
    }

    public void onNetChange() {
        for (Runnable runnable : this.onNetChangeRunnables) {
            runnable.run();
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.onNetChange();
    }

    public void onLoad() {
        super.onLoad();
        this.refreshNetCache();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setNetId(tag.m_128451_("netId"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("netId", this.netId);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public @Nullable Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

