/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Fluid;

import com.wintercogs.beyonddimensions.Block.ModBlocks;
import com.wintercogs.beyonddimensions.Fluid.Custom.XpFluid;
import com.wintercogs.beyonddimensions.Item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"beyonddimensions");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUIDS, (String)"beyonddimensions");
    public static final List<FluidEntry<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing>> ALL = new ArrayList<FluidEntry<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing>>();
    public static final FluidEntry<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing> XP_FLUID = ModFluids.registerFluid("xp_fluid", FluidType.Properties.create().lightLevel(10).density(800).viscosity(1500), -1, 10, XpFluid.Source::new, XpFluid.Flowing::new);

    public static <S extends ForgeFlowingFluid.Source, F extends ForgeFlowingFluid.Flowing> FluidEntry<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing> registerFluid(final String name, FluidType.Properties typeProps, final int argbTint, int lightlevel, Function<ForgeFlowingFluid.Properties, S> sourceCtor, Function<ForgeFlowingFluid.Properties, F> flowingCtor) {
        RegistryObject type = FLUID_TYPES.register(name, () -> new FluidType(typeProps){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                super.initializeClient(consumer);
                final ResourceLocation still = ResourceLocation.m_214293_((String)"beyonddimensions", (String)("block/" + name + "_still"));
                final ResourceLocation flow = ResourceLocation.m_214293_((String)"beyonddimensions", (String)("block/" + name + "_flow"));
                final int tint = argbTint;
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return still;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return flow;
                    }

                    public int getTintColor() {
                        return tint;
                    }
                });
            }
        });
        ForgeFlowingFluid.Properties[] propsRef = new ForgeFlowingFluid.Properties[1];
        RegistryObject source = FLUIDS.register(name, () -> (ForgeFlowingFluid.Source)sourceCtor.apply(propsRef[0]));
        RegistryObject flowing = FLUIDS.register("flowing_" + name, () -> (ForgeFlowingFluid.Flowing)flowingCtor.apply(propsRef[0]));
        RegistryObject block = ModBlocks.BLOCKS.register(name, () -> new LiquidBlock((FlowingFluid)source.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_60953_(s -> lightlevel)));
        RegistryObject bucket = ModItems.ITEMS.register(name + "_bucket", () -> new BucketItem((Fluid)source.get(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
        propsRef[0] = new ForgeFlowingFluid.Properties((Supplier)type, (Supplier)source, (Supplier)flowing).bucket((Supplier)bucket).block((Supplier)block).slopeFindDistance(4).levelDecreasePerBlock(2);
        FluidEntry<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing> entry = new FluidEntry<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing>(name, (RegistryObject<FluidType>)type, source, flowing, (RegistryObject<LiquidBlock>)block, (RegistryObject<Item>)bucket, argbTint);
        ALL.add(entry);
        return entry;
    }

    public static FluidEntry<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing> registerSimpleFluid(String name, FluidType.Properties typeProps, int argbTint, int lightlevel) {
        return ModFluids.registerFluid(name, typeProps, argbTint, lightlevel, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new);
    }

    public static void register(IEventBus modBus) {
        FLUID_TYPES.register(modBus);
        FLUIDS.register(modBus);
    }

    public record FluidEntry<S extends ForgeFlowingFluid.Source, F extends ForgeFlowingFluid.Flowing>(String name, RegistryObject<FluidType> type, RegistryObject<S> source, RegistryObject<F> flowing, RegistryObject<LiquidBlock> block, RegistryObject<Item> bucket, int argbTint) {
    }

    @Mod.EventBusSubscriber(modid="beyonddimensions", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static final class ClientOnly {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent evt) {
            evt.enqueueWork(() -> {
                for (FluidEntry<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing> e : ALL) {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)e.source().get()), (RenderType)RenderType.m_110466_());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)e.flowing().get()), (RenderType)RenderType.m_110466_());
                }
            });
        }
    }
}

