/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI.SharedWidget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ScrollBar
extends AbstractWidget {
    protected final ResourceLocation SPRITE;
    protected int maxScrollLength;
    protected int currentPosition;
    protected int maxPosition;
    protected int step = 1;
    protected int scrollerOffset = 0;
    protected boolean alignCenterToMouse = true;
    protected boolean isDragging = false;
    @Nullable
    protected IntConsumer onScroll;

    public ScrollBar(int x, int y, int width, int height, ResourceLocation sprite, int maxScrollLen, int currentPos, int maxPos, @Nullable IntConsumer onScroll, Component message) {
        super(x, y, width, height, message);
        this.SPRITE = sprite;
        this.maxScrollLength = Math.max(0, maxScrollLen);
        this.maxPosition = Math.max(0, maxPos);
        this.onScroll = onScroll;
        this.setCurrentPosition(currentPos);
    }

    public void setOnScroll(@Nullable IntConsumer cb) {
        this.onScroll = cb;
    }

    public void setAlignCenterToMouse(boolean center) {
        this.alignCenterToMouse = center;
    }

    public void updateScrollPosition(int currentPosition, int maxPosition) {
        this.maxPosition = Math.max(0, maxPosition);
        this.setCurrentPosition(currentPosition);
    }

    public void setMaxScrollLength(int maxScrollLength) {
        this.maxScrollLength = Math.max(0, maxScrollLength);
    }

    public void setStep(int step) {
        this.step = Math.max(1, step);
        this.setCurrentPosition(this.currentPosition);
    }

    public int getStep() {
        return this.step;
    }

    public void scrollBySteps(int steps) {
        if (this.maxPosition <= 0) {
            return;
        }
        int unit = Math.max(1, this.step);
        long target = (long)this.currentPosition + (long)steps * (long)unit;
        this.setCurrentPosition((int)Mth.m_14036_((float)target, (float)0.0f, (float)this.maxPosition));
    }

    public void scrollToMouse(double mouseY) {
        if (this.maxPosition <= 0 || this.maxScrollLength <= 0) {
            return;
        }
        double anchorOffset = this.alignCenterToMouse ? (double)this.m_93694_() / 2.0 : 0.0;
        double relative = (mouseY - (double)this.m_252907_() - anchorOffset) / (double)this.maxScrollLength;
        double clamped = Mth.m_14008_((double)relative, (double)0.0, (double)1.0);
        int pos = (int)Math.round(clamped * (double)this.maxPosition);
        this.setCurrentPosition(pos);
    }

    public void setCurrentPosition(int pos) {
        int clamped = Mth.m_14045_((int)pos, (int)0, (int)Math.max(0, this.maxPosition));
        int quantized = this.quantizeToStep(clamped);
        if (quantized != this.currentPosition) {
            this.currentPosition = quantized;
            if (this.onScroll != null) {
                this.onScroll.accept(this.currentPosition);
            }
        }
    }

    protected int quantizeToStep(int value) {
        if (this.step <= 1) {
            return value;
        }
        int q = Math.round((float)value / (float)this.step) * this.step;
        return Mth.m_14045_((int)q, (int)0, (int)Math.max(0, this.maxPosition));
    }

    protected int computeOffset() {
        if (this.maxPosition > 0 && this.maxScrollLength > 0) {
            return (int)Math.round((double)this.maxScrollLength * ((double)this.currentPosition / (double)this.maxPosition));
        }
        return 0;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        int left = this.m_252754_();
        int right = left + this.m_5711_();
        int top = this.m_252907_();
        int bottom = top + this.maxScrollLength + this.m_93694_();
        return mouseX >= (double)left && mouseX < (double)right && mouseY >= (double)top && mouseY < (double)bottom;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        if (!this.m_7972_(button)) {
            return false;
        }
        if (this.m_5953_(mouseX, mouseY)) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.m_5716_(mouseX, mouseY);
            this.isDragging = true;
            this.scrollToMouse(mouseY);
            return true;
        }
        return false;
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        if (!this.isDragging) {
            return;
        }
        this.scrollToMouse(mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.isDragging = false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        if (this.maxPosition <= 0) {
            return false;
        }
        int dir = (int)Math.signum(delta);
        if (dir != 0) {
            this.scrollBySteps(-dir);
            return true;
        }
        return false;
    }

    protected void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTick) {
        this.scrollerOffset = this.computeOffset();
        gg.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        gg.m_280163_(this.SPRITE, this.m_252754_(), this.m_252907_() + this.scrollerOffset, 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
        gg.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void m_168797_(NarrationElementOutput out) {
        out.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            if (this.m_93696_()) {
                out.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"beyonddimensions.scrollbar.usage.focused"));
            } else {
                out.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"beyonddimensions.scrollbar.usage.hovered"));
            }
        }
    }
}

