/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI.SharedWidget;

import com.wintercogs.beyonddimensions.GUI.SharedWidget.IconButton;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.resources.ResourceLocation;

public abstract class StatusButton
extends IconButton {
    protected ArrayList<Enum<?>> states = new ArrayList();
    protected Map<Enum<?>, ResourceLocation> iconMap = new LinkedHashMap();
    protected Map<Enum<?>, Tooltip> tooltipMap = new LinkedHashMap();
    public Enum<?> currentState;

    protected StatusButton(int x, int y, int width, int height, int iconX, int iconY, int iconWidth, int iconHeight, Button.OnPress onPress) {
        super(x, y, width, height, ResourceLocation.m_214293_((String)"beyonddimensions", (String)"widget/unkonw_thing"), iconX, iconY, iconWidth, iconHeight, onPress);
        this.initButton();
        this.setIcon(this.iconMap.get(this.currentState));
    }

    protected StatusButton(int x, int y, int width, int height, Button.OnPress onPress) {
        this(x, y, width, height, x, y, width, height, onPress);
    }

    protected abstract void initButton();

    public void toggleState() {
        if (this.states == null || this.states.isEmpty()) {
            throw new IllegalStateException("Button states are not initialized.");
        }
        int currentIndex = this.states.indexOf(this.currentState);
        if (currentIndex == -1) {
            throw new IllegalStateException("Current state is not in the states list.");
        }
        int nextIndex = (currentIndex + 1) % this.states.size();
        this.currentState = this.states.get(nextIndex);
        this.setIcon(this.iconMap.get(this.currentState));
        if (this.tooltipMap != null && this.tooltipMap.containsKey(this.currentState) && this.tooltipMap.get(this.currentState) != null) {
            this.m_257544_(this.tooltipMap.get(this.currentState));
        }
    }

    public void setState(Enum<?> state) {
        this.currentState = state;
        this.setIcon(this.iconMap.get(this.currentState));
        if (this.tooltipMap != null && this.tooltipMap.containsKey(this.currentState) && this.tooltipMap.get(this.currentState) != null) {
            this.m_257544_(this.tooltipMap.get(this.currentState));
        }
    }
}

