/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.Ars.Block;

import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.source.SourceManager;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.SourceStackType;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Integration.Ars.Caps.SourcePathwayProvider;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class SourcePathwayBlockEntity
extends NetedBlockEntity
implements ISourceTile {
    public SourcePathwayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.ARS_SOURCE_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
    }

    public int getTransferRate() {
        return this.getNet() != null ? Integer.MAX_VALUE : 0;
    }

    public boolean canAcceptSource() {
        return this.getNet() != null;
    }

    public int getSource() {
        IStackType<?> stack;
        DimensionsNet net = this.getNet();
        if (net != null && (stack = net.getUnifiedStorage().getStackByStack(new SourceStackType(0L))) != null) {
            return BDMath.clampLongToInt(stack.getStackAmount());
        }
        return 0;
    }

    public int getMaxSource() {
        return Integer.MAX_VALUE;
    }

    public void setMaxSource(int amount) {
    }

    public int setSource(int amount) {
        return this.getSource();
    }

    public int addSource(int amount) {
        DimensionsNet net = this.getNet();
        if (net != null) {
            net.getUnifiedStorage().insert(new SourceStackType(amount), false).getStackAmount();
        }
        return this.getSource();
    }

    public int removeSource(int amount) {
        DimensionsNet net = this.getNet();
        if (net != null) {
            net.getUnifiedStorage().extract(new SourceStackType(amount), false).getStackAmount();
        }
        return this.getSource();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.m_5776_() && this.getNet() != null) {
            SourceManager.INSTANCE.addInterface(this.f_58857_, (ISpecialSourceProvider)new SourcePathwayProvider(this));
        }
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.getNet() != null) {
            SourceManager.INSTANCE.addInterface(this.f_58857_, (ISpecialSourceProvider)new SourcePathwayProvider(this));
        }
    }
}

