/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.RS.ExternalStorage;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.refinedmods.refinedstorage.api.util.Action;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Integration.RS.Block.RSNetPathwayBlockEntity;
import com.wintercogs.beyonddimensions.Integration.RS.RSHelper;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public class BD_RS120ExternalStorageFluids
implements IExternalStorage<FluidStack> {
    private final IExternalStorageContext ctx;
    private final BlockPos targetPos;
    private final ServerLevel level;
    private volatile boolean active = true;
    @Nullable
    private volatile UnifiedStorage unified;
    @Nullable
    private AutoCloseable unifiedAnySub;
    @Nullable
    private AutoCloseable unifiedDeltaSub;
    private final Object2IntOpenHashMap<FluidKey> indexByKey = new Object2IntOpenHashMap();
    private final ArrayList<FluidKey> keys = new ArrayList();
    private final ArrayList<FluidStack> all = new ArrayList();
    private final Deque<Delta> deltaQueue = new ArrayDeque<Delta>();
    private final List<FluidStack> pendingClear = new ArrayList<FluidStack>();
    private volatile boolean needClearOnce = false;
    private final List<FluidStack> pendingBaseline = new ArrayList<FluidStack>();
    private volatile boolean needBaselineOnce = false;
    @Nullable
    private Runnable netChangeListener;

    public BD_RS120ExternalStorageFluids(IExternalStorageContext ctx, ServerLevel level, BlockPos targetPos, UnifiedStorage unified) {
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        this.level = Objects.requireNonNull(level, "level");
        this.targetPos = Objects.requireNonNull(targetPos, "targetPos");
        this.unified = Objects.requireNonNull(unified, "unified");
        this.indexByKey.defaultReturnValue(-1);
        this.fullRebuild();
        this.subscribeUnified(unified);
    }

    public void attachTo(RSNetPathwayBlockEntity rsBe) {
        if (this.netChangeListener == null) {
            this.netChangeListener = this::onNetChanged;
            rsBe.addNetChangeTask(this.netChangeListener);
        }
        rsBe.addRemoveTask(this::onHostRemoved);
        this.onNetChanged();
    }

    public void update(INetwork network) {
        Delta d;
        IStorageCache cache = network.getFluidStorageCache();
        if (this.needClearOnce && !this.pendingClear.isEmpty()) {
            for (FluidStack prev : this.pendingClear) {
                if (prev.isEmpty() || prev.getAmount() <= 0) continue;
                cache.remove((Object)prev, Math.min(prev.getAmount(), Integer.MAX_VALUE), true);
            }
            this.pendingClear.clear();
            this.needClearOnce = false;
            cache.flush();
        }
        if (this.needBaselineOnce && !this.pendingBaseline.isEmpty()) {
            for (FluidStack base : this.pendingBaseline) {
                if (base.isEmpty() || base.getAmount() <= 0) continue;
                cache.add((Object)base, Math.min(base.getAmount(), Integer.MAX_VALUE), false, true);
            }
            this.pendingBaseline.clear();
            this.needBaselineOnce = false;
            cache.flush();
        }
        boolean changed = false;
        while ((d = this.deltaQueue.pollFirst()) != null) {
            if (d.diff > 0L) {
                cache.add((Object)d.key, (int)Math.min(d.diff, Integer.MAX_VALUE), false, true);
                changed = true;
                continue;
            }
            if (d.diff >= 0L) continue;
            cache.remove((Object)d.key, (int)Math.min(-d.diff, Integer.MAX_VALUE), true);
            changed = true;
        }
        if (changed) {
            cache.flush();
        }
    }

    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    public List<FluidStack> getStacks() {
        return Collections.unmodifiableList(this.all);
    }

    public FluidStack insert(FluidStack prototype, int size, Action action) {
        if (!this.active || this.unified == null) {
            return prototype.copy();
        }
        if (prototype.isEmpty() || size <= 0) {
            return FluidStack.EMPTY;
        }
        if (this.ctx.getAccessType() == AccessType.EXTRACT) {
            return prototype.copy();
        }
        if (!this.ctx.acceptsFluid(prototype)) {
            return prototype.copy();
        }
        long before = size;
        long inserted = RSHelper.fromFluidStackToIStack(prototype, size).map(s -> (long)size - RSHelper.fromFluidStackToIStack(prototype, size).map(ss -> this.unified.insert((IStackType<?>)ss, action == Action.SIMULATE).getStackAmount()).orElse(0L)).orElse(0L);
        long remainder = before - inserted;
        if (remainder <= 0L) {
            return FluidStack.EMPTY;
        }
        FluidStack rem = prototype.copy();
        rem.setAmount((int)Math.min(remainder, Integer.MAX_VALUE));
        return rem;
    }

    public FluidStack extract(FluidStack prototype, int size, int flags, Action action) {
        boolean quantityStrict;
        if (!this.active || this.unified == null) {
            return FluidStack.EMPTY;
        }
        if (prototype.isEmpty() || size <= 0) {
            return FluidStack.EMPTY;
        }
        if (this.ctx.getAccessType() == AccessType.INSERT) {
            return FluidStack.EMPTY;
        }
        Optional<FluidStackType> reqOpt = RSHelper.fromFluidStackToIStack(prototype, size);
        if (reqOpt.isEmpty()) {
            return FluidStack.EMPTY;
        }
        IStackType req = reqOpt.get();
        long can = this.unified.extract(req, true).getStackAmount();
        if (can <= 0L) {
            return FluidStack.EMPTY;
        }
        boolean bl = quantityStrict = (flags & 2) == 2;
        if (quantityStrict && can < (long)size) {
            return FluidStack.EMPTY;
        }
        int want = (int)Math.min(can, (long)size);
        if (want <= 0) {
            return FluidStack.EMPTY;
        }
        if (action == Action.SIMULATE) {
            FluidStack out = prototype.copy();
            out.setAmount(want);
            return out;
        }
        long took = this.unified.extract(req.copyWithCount(want), false).getStackAmount();
        if (took <= 0L) {
            return FluidStack.EMPTY;
        }
        FluidStack out = prototype.copy();
        out.setAmount((int)Math.min(took, Integer.MAX_VALUE));
        return out;
    }

    public int getStored() {
        return 0;
    }

    public int getPriority() {
        return this.ctx.getPriority();
    }

    public AccessType getAccessType() {
        return this.ctx.getAccessType();
    }

    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        int rem = remainder == null ? 0 : remainder.getAmount();
        int delta = size - rem;
        return Math.max(0, Math.min(delta, Integer.MAX_VALUE));
    }

    private void onNetChanged() {
        BlockEntity be = this.level.m_7702_(this.targetPos);
        DimensionsNet net = null;
        if (be instanceof RSNetPathwayBlockEntity) {
            RSNetPathwayBlockEntity rsBe = (RSNetPathwayBlockEntity)be;
            net = rsBe.getNet();
        }
        if (net == null) {
            this.active = false;
            this.unsubscribeUnified();
            this.unified = null;
            if (!this.all.isEmpty()) {
                this.pendingClear.clear();
                for (FluidStack s : this.all) {
                    this.pendingClear.add(s.copy());
                }
                this.needClearOnce = true;
            }
            this.indexByKey.clear();
            this.keys.clear();
            this.all.clear();
            this.deltaQueue.clear();
        } else {
            UnifiedStorage newUnified = net.getUnifiedStorage();
            if (newUnified != this.unified) {
                this.unsubscribeUnified();
                this.unified = newUnified;
                this.subscribeUnified(newUnified);
                this.fullRebuild();
                this.pendingBaseline.clear();
                for (FluidStack s : this.all) {
                    this.pendingBaseline.add(s.copy());
                }
                this.needBaselineOnce = !this.pendingBaseline.isEmpty();
            }
            this.active = true;
        }
    }

    private void fullRebuild() {
        this.indexByKey.clear();
        this.keys.clear();
        this.all.clear();
        UnifiedStorage u = this.unified;
        if (u == null) {
            return;
        }
        for (IStackType<?> s : u.getStorage()) {
            if (s.isEmpty()) continue;
            RSHelper.fromIStackToFluidStack(s).ifPresent(fs -> {
                if (!this.ctx.acceptsFluid(fs)) {
                    return;
                }
                FluidKey key = FluidKey.from(fs);
                int idx = this.indexByKey.getInt((Object)key);
                long amt = s.getStackAmount();
                if (idx < 0) {
                    FluidStack view = fs.copy();
                    view.setAmount((int)Math.min(amt, Integer.MAX_VALUE));
                    int newIdx = this.all.size();
                    this.indexByKey.put((Object)key, newIdx);
                    this.keys.add(key);
                    this.all.add(view);
                } else {
                    FluidStack exist = this.all.get(idx);
                    long now = (long)exist.getAmount() + amt;
                    exist.setAmount((int)Math.min(now, Integer.MAX_VALUE));
                }
            });
        }
    }

    private void applyDeltaToView(FluidStack keyStack, long diff) {
        if (diff == 0L) {
            return;
        }
        FluidKey key = FluidKey.from(keyStack);
        int idx = this.indexByKey.getInt((Object)key);
        if (diff > 0L) {
            if (idx >= 0) {
                FluidStack cur = this.all.get(idx);
                long now = (long)cur.getAmount() + diff;
                cur.setAmount((int)Math.min(now, Integer.MAX_VALUE));
            } else {
                FluidStack add = keyStack.copy();
                add.setAmount((int)Math.min(diff, Integer.MAX_VALUE));
                int newIdx = this.all.size();
                this.indexByKey.put((Object)key, newIdx);
                this.keys.add(key);
                this.all.add(add);
            }
        } else if (idx >= 0) {
            FluidStack cur = this.all.get(idx);
            long now = (long)cur.getAmount() + diff;
            if (now > 0L) {
                cur.setAmount((int)Math.max(0L, Math.min(now, Integer.MAX_VALUE)));
            } else {
                int last = this.all.size() - 1;
                if (idx != last) {
                    FluidStack tailStack = this.all.get(last);
                    FluidKey tailKey = this.keys.get(last);
                    this.all.set(idx, tailStack);
                    this.keys.set(idx, tailKey);
                    this.indexByKey.put((Object)tailKey, idx);
                }
                this.all.remove(last);
                this.keys.remove(last);
                this.indexByKey.remove((Object)key);
            }
        }
    }

    private void subscribeUnified(UnifiedStorage u) {
        this.unifiedAnySub = u.subscribeAnyWeak(this, storageItems -> this.level.m_7654_().execute(this::fullRebuild));
        this.unifiedDeltaSub = u.subscribeDeltaWeak(this, (storageItems, type, size, insert) -> RSHelper.fromIStackToFluidStack(type).ifPresent(fs -> {
            if (!this.ctx.acceptsFluid(fs)) {
                return;
            }
            long diff = insert != false ? size : -size.longValue();
            this.applyDeltaToView((FluidStack)fs, diff);
            this.deltaQueue.addLast(new Delta(fs.copy(), diff));
        }));
    }

    private void unsubscribeUnified() {
        if (this.unifiedAnySub != null) {
            try {
                this.unifiedAnySub.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unifiedAnySub = null;
        }
        if (this.unifiedDeltaSub != null) {
            try {
                this.unifiedDeltaSub.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unifiedDeltaSub = null;
        }
    }

    private void onHostRemoved() {
        if (!this.active && this.unified == null && this.all.isEmpty() && this.deltaQueue.isEmpty()) {
            return;
        }
        this.active = false;
        this.unsubscribeUnified();
        this.unified = null;
        if (!this.all.isEmpty()) {
            this.pendingClear.clear();
            for (FluidStack s : this.all) {
                if (s.isEmpty() || s.getAmount() <= 0) continue;
                this.pendingClear.add(s.copy());
            }
            this.needClearOnce = true;
        }
        this.indexByKey.clear();
        this.keys.clear();
        this.all.clear();
        this.deltaQueue.clear();
    }

    public void close() {
        this.unsubscribeUnified();
        this.netChangeListener = null;
        this.unified = null;
        this.deltaQueue.clear();
        this.pendingClear.clear();
        this.pendingBaseline.clear();
        this.active = false;
        this.indexByKey.clear();
        this.keys.clear();
        this.all.clear();
    }

    private static final class Delta {
        final FluidStack key;
        final long diff;

        Delta(FluidStack key, long diff) {
            this.key = key;
            this.diff = diff;
        }
    }

    private static final class FluidKey {
        private final CompoundTag keyNbt;
        private final int hash;

        private FluidKey(CompoundTag keyNbt) {
            this.keyNbt = keyNbt;
            this.hash = keyNbt.hashCode();
        }

        static FluidKey from(FluidStack stack) {
            CompoundTag tag = new CompoundTag();
            stack.writeToNBT(tag);
            tag.m_128405_("Amount", 1);
            return new FluidKey(tag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FluidKey)) {
                return false;
            }
            FluidKey other = (FluidKey)o;
            return this.keyNbt.equals((Object)other.keyNbt);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

