/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Item.Custom.NetedItem;
import com.wintercogs.beyonddimensions.Machine.BaseMachine;
import com.wintercogs.beyonddimensions.Machine.FeederMode;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Machine.HopperFluidMode;
import com.wintercogs.beyonddimensions.Machine.HopperItemMode;
import com.wintercogs.beyonddimensions.Machine.HopperNBTMode;
import com.wintercogs.beyonddimensions.Machine.HopperRangeMode;
import com.wintercogs.beyonddimensions.Machine.HopperXpMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMachineItem
extends NetedItem
implements BaseMachine {
    public BaseMachineItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        this.checkComponents(stack);
        if (level.m_5776_()) {
            return;
        }
        if (this.getTicksPerWork(stack, level, entity, slotId, isSelected) <= 0) {
            this.working(stack, level, entity, slotId, isSelected);
        } else if (level.m_46467_() % (long)this.getTicksPerWork(stack, level, entity, slotId, isSelected) == 0L) {
            this.working(stack, level, entity, slotId, isSelected);
        }
    }

    public void checkComponents(ItemStack stack) {
        if (!BaseMachineItem.hasControlMode(stack)) {
            BaseMachineItem.setControlMode(stack, RedStoneControlMode.IGNORE);
        }
    }

    @Override
    public void workStart(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        BaseMachine.super.workStart(stack, level, holder, slotId, isSelected);
    }

    @Override
    public RedStoneControlMode getControlMode() {
        return RedStoneControlMode.IGNORE;
    }

    @Override
    public RedStoneControlMode getControlMode(ItemStack stack) {
        return BaseMachineItem.getControlModeOrDefault(stack, RedStoneControlMode.IGNORE);
    }

    @Override
    public boolean hasRedStoneSignal() {
        return false;
    }

    @Override
    public int getStepTick() {
        return 0;
    }

    @Override
    public void setStepTick(int newTick) {
    }

    public static RedStoneControlMode getControlModeOrDefault(ItemStack stack, @Nullable RedStoneControlMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("control_mode")) {
            return RedStoneControlMode.valueOf(stack.m_41783_().m_128461_("control_mode"));
        }
        return defaultValue;
    }

    public static void setControlMode(ItemStack stack, RedStoneControlMode newMode) {
        stack.m_41784_().m_128359_("control_mode", newMode.name());
    }

    public static boolean hasControlMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("control_mode");
    }

    public static FilterMode getFilterModeOrDefault(ItemStack stack, @Nullable FilterMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("filter_mode")) {
            return FilterMode.valueOf(stack.m_41783_().m_128461_("filter_mode"));
        }
        return defaultValue;
    }

    public static void setFilterMode(ItemStack stack, FilterMode newMode) {
        stack.m_41784_().m_128359_("filter_mode", newMode.name());
    }

    public static boolean hasFilterMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("filter_mode");
    }

    public static HopperItemMode getHopperItemModeOrDefault(ItemStack stack, @Nullable HopperItemMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("hopper_item_mode")) {
            return HopperItemMode.valueOf(stack.m_41783_().m_128461_("hopper_item_mode"));
        }
        return defaultValue;
    }

    public static void setHopperItemMode(ItemStack stack, HopperItemMode newMode) {
        stack.m_41784_().m_128359_("hopper_item_mode", newMode.name());
    }

    public static boolean hasHopperItemMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("hopper_item_mode");
    }

    public static HopperXpMode getHopperXpModeOrDefault(ItemStack stack, @Nullable HopperXpMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("hopper_xp_mode")) {
            return HopperXpMode.valueOf(stack.m_41783_().m_128461_("hopper_xp_mode"));
        }
        return defaultValue;
    }

    public static void setHopperXpMode(ItemStack stack, HopperXpMode newMode) {
        stack.m_41784_().m_128359_("hopper_xp_mode", newMode.name());
    }

    public static boolean hasHopperXpMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("hopper_xp_mode");
    }

    public static HopperNBTMode getHopperNBTModeOrDefault(ItemStack stack, @Nullable HopperNBTMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("hopper_nbt_mode")) {
            return HopperNBTMode.valueOf(stack.m_41783_().m_128461_("hopper_nbt_mode"));
        }
        return defaultValue;
    }

    public static void setHopperNBTMode(ItemStack stack, HopperNBTMode newMode) {
        stack.m_41784_().m_128359_("hopper_nbt_mode", newMode.name());
    }

    public static boolean hasHopperNBTMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("hopper_nbt_mode");
    }

    public static HopperFluidMode getHopperFluidModeOrDefault(ItemStack stack, @Nullable HopperFluidMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("hopper_fluid_mode")) {
            return HopperFluidMode.valueOf(stack.m_41783_().m_128461_("hopper_fluid_mode"));
        }
        return defaultValue;
    }

    public static void setHopperFluidMode(ItemStack stack, HopperFluidMode newMode) {
        stack.m_41784_().m_128359_("hopper_fluid_mode", newMode.name());
    }

    public static boolean hasHopperFluidMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("hopper_fluid_mode");
    }

    public static HopperRangeMode getHopperRangeModeOrDefault(ItemStack stack, @Nullable HopperRangeMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("hopper_range_mode")) {
            return HopperRangeMode.valueOf(stack.m_41783_().m_128461_("hopper_range_mode"));
        }
        return defaultValue;
    }

    public static void setHopperRangeMode(ItemStack stack, HopperRangeMode newMode) {
        stack.m_41784_().m_128359_("hopper_range_mode", newMode.name());
    }

    public static boolean hasHopperRangeMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("hopper_range_mode");
    }

    public static FeederMode getFeederModeOrDefault(ItemStack stack, @Nullable FeederMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("feeder_mode")) {
            return FeederMode.valueOf(stack.m_41783_().m_128461_("feeder_mode"));
        }
        return defaultValue;
    }

    public static void setFeederMode(ItemStack stack, FeederMode newMode) {
        stack.m_41784_().m_128359_("feeder_mode", newMode.name());
    }

    public static boolean hasFeederMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("feeder_mode");
    }

    public static List<IStackType<?>> getFilterSlotsOrDefault(ItemStack stack, @Nullable List<IStackType<?>> defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("filter_slots")) {
            ListTag tags = stack.m_41783_().m_128437_("filter_slots", 10);
            ArrayList filterSlots = new ArrayList();
            for (int i = 0; i < tags.size(); ++i) {
                filterSlots.add(IStackType.deserializeNBTCommon(tags.m_128728_(i)));
            }
            return filterSlots;
        }
        return defaultValue;
    }

    public static void setFilterSlots(ItemStack stack, List<IStackType<?>> filterSlots) {
        ListTag tags = new ListTag();
        for (int i = 0; i < filterSlots.size(); ++i) {
            tags.add((Object)filterSlots.get(i).serializeNBT());
        }
        stack.m_41784_().m_128365_("filter_slots", (Tag)tags);
    }

    public static boolean hasFilterSlots(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("filter_slots");
    }
}

