/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Item.Custom.BaseMachineItem;
import com.wintercogs.beyonddimensions.Item.Custom.NetedItem;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Machine.HopperFluidMode;
import com.wintercogs.beyonddimensions.Machine.HopperItemMode;
import com.wintercogs.beyonddimensions.Machine.HopperNBTMode;
import com.wintercogs.beyonddimensions.Machine.HopperRangeMode;
import com.wintercogs.beyonddimensions.Machine.HopperXpMode;
import com.wintercogs.beyonddimensions.Menu.NetMagnetMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class NetMagnetItem
extends BaseMachineItem {
    public static final int capacity = 36;

    public NetMagnetItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        super.m_7203_(level, player, usedHand);
        ItemStack itemstack = player.m_21120_(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || player.m_6144_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!level.m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((containerId, inv, ServerPlayer2) -> new NetMagnetMenu(containerId, inv, itemstack), (Component)Component.m_237115_((String)"menu.title.beyonddimensions.magnet_menu")), buf -> buf.m_130068_((Enum)usedHand));
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    @Override
    public void checkComponents(ItemStack stack) {
        super.checkComponents(stack);
        if (!NetMagnetItem.hasFilterSlots(stack)) {
            NetMagnetItem.setFilterSlots(stack, new ArrayList(Collections.nCopies(36, new ItemStackType())));
        }
        if (!NetMagnetItem.hasFilterMode(stack)) {
            NetMagnetItem.setFilterMode(stack, FilterMode.BLACK);
        }
        if (!NetMagnetItem.hasHopperItemMode(stack)) {
            NetMagnetItem.setHopperItemMode(stack, HopperItemMode.ALLOW);
        }
        if (!NetMagnetItem.hasHopperXpMode(stack)) {
            NetMagnetItem.setHopperXpMode(stack, HopperXpMode.DENY);
        }
        if (!NetMagnetItem.hasHopperNBTMode(stack)) {
            NetMagnetItem.setHopperNBTMode(stack, HopperNBTMode.DENY);
        }
        if (!NetMagnetItem.hasHopperFluidMode(stack)) {
            NetMagnetItem.setHopperFluidMode(stack, HopperFluidMode.DENY);
        }
        if (!NetMagnetItem.hasHopperRangeMode(stack)) {
            NetMagnetItem.setHopperRangeMode(stack, HopperRangeMode.RADIUS_MID);
        }
    }

    @Override
    public boolean shouldWork(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        return super.shouldWork(stack, level, holder, slotId, isSelected) && NetedItem.getNet(stack, level.m_7654_()) != null;
    }

    @Override
    public void workContent(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        super.workContent(stack, level, holder, slotId, isSelected);
        FilterMode filterMode = NetMagnetItem.getFilterModeOrDefault(stack, FilterMode.BLACK);
        HopperItemMode hopperItemMode = NetMagnetItem.getHopperItemModeOrDefault(stack, HopperItemMode.ALLOW);
        HopperXpMode hopperXpMode = NetMagnetItem.getHopperXpModeOrDefault(stack, HopperXpMode.DENY);
        HopperNBTMode hopperNBTMode = NetMagnetItem.getHopperNBTModeOrDefault(stack, HopperNBTMode.DENY);
        HopperFluidMode hopperFluidMode = NetMagnetItem.getHopperFluidModeOrDefault(stack, HopperFluidMode.DENY);
        HopperRangeMode hopperRangeMode = NetMagnetItem.getHopperRangeModeOrDefault(stack, HopperRangeMode.RADIUS_MID);
        List<IStackType<?>> filterSlots = NetMagnetItem.getFilterSlotsOrDefault(stack, new ArrayList());
        AABB searchArea = this.getSearchArea(hopperRangeMode, level, (Vec3i)holder.m_20097_());
        ArrayList itemEntities = hopperItemMode == HopperItemMode.ALLOW ? this.refreshItemEntityCache(hopperNBTMode, level, searchArea) : new ArrayList();
        List<Object> xpEntities = hopperXpMode == HopperXpMode.ALLOW ? this.refreshXpEntityCache(level, searchArea) : new ArrayList();
        UnifiedStorage storage = NetedItem.getNet(stack, level.m_7654_()).getUnifiedStorage();
        if (hopperItemMode == HopperItemMode.ALLOW) {
            for (ItemEntity itemEntity : itemEntities) {
                ItemStack itemStack;
                ItemStackType typedStack;
                if (itemEntity == null || itemEntity.m_213877_() || !this.matchesFilter(filterMode, filterSlots, typedStack = new ItemStackType(itemStack = itemEntity.m_32055_().m_41777_())) || !storage.insert(typedStack, true).isEmpty()) continue;
                itemEntity.m_146870_();
                storage.insert(typedStack, false);
            }
        }
        if (hopperXpMode == HopperXpMode.ALLOW) {
            for (ExperienceOrb experienceOrb : xpEntities) {
                int xp;
                if (experienceOrb == null || experienceOrb.m_213877_() || (xp = experienceOrb.m_20801_()) <= 0) continue;
                long xpFluid = (long)xp * 20L;
                FluidStackType xpStack = new FluidStackType(new FluidStack((Fluid)ModFluids.XP_FLUID.source().get(), 1), xpFluid);
                if (!storage.insert(xpStack, true).isEmpty()) continue;
                experienceOrb.m_146870_();
                storage.insert(xpStack, false);
            }
        }
        if (hopperFluidMode == HopperFluidMode.ALLOW) {
            this.fluidCollect(filterMode, filterSlots, storage, level, searchArea);
        }
    }

    @Override
    public int getTicksPerWork(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        HopperRangeMode hopperRangeMode = NetMagnetItem.getHopperRangeModeOrDefault(stack, HopperRangeMode.RADIUS_MID);
        HopperFluidMode hopperFluidMode = NetMagnetItem.getHopperFluidModeOrDefault(stack, HopperFluidMode.DENY);
        if (hopperFluidMode == HopperFluidMode.ALLOW) {
            return switch (hopperRangeMode) {
                default -> throw new IncompatibleClassChangeError();
                case HopperRangeMode.RADIUS_LOWEST -> 0;
                case HopperRangeMode.RADIUS_LOW -> 0;
                case HopperRangeMode.RADIUS_MID -> 10;
                case HopperRangeMode.RADIUS_HIGH -> 20;
                case HopperRangeMode.RADIUS_HIGHEST -> 50;
                case HopperRangeMode.CHUNK_MODE -> 1200;
            };
        }
        return switch (hopperRangeMode) {
            default -> throw new IncompatibleClassChangeError();
            case HopperRangeMode.RADIUS_LOWEST -> 0;
            case HopperRangeMode.RADIUS_LOW -> 0;
            case HopperRangeMode.RADIUS_MID -> 2;
            case HopperRangeMode.RADIUS_HIGH -> 5;
            case HopperRangeMode.RADIUS_HIGHEST -> 10;
            case HopperRangeMode.CHUNK_MODE -> 1200;
        };
    }

    private AABB getSearchArea(HopperRangeMode hopperRangeMode, Level level, Vec3i pos) {
        if (hopperRangeMode != HopperRangeMode.CHUNK_MODE) {
            int radius = switch (hopperRangeMode) {
                case HopperRangeMode.RADIUS_LOWEST -> 2;
                case HopperRangeMode.RADIUS_LOW -> 3;
                case HopperRangeMode.RADIUS_MID -> 5;
                case HopperRangeMode.RADIUS_HIGH -> 7;
                case HopperRangeMode.RADIUS_HIGHEST -> 10;
                default -> 1;
            };
            return new AABB((double)(pos.m_123341_() - radius), (double)(pos.m_123342_() - radius), (double)(pos.m_123343_() - radius), (double)(pos.m_123341_() + radius), (double)(pos.m_123342_() + radius), (double)(pos.m_123343_() + radius));
        }
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        int minX = chunkX << 4;
        int maxX = minX + 15;
        int minZ = chunkZ << 4;
        int maxZ = minZ + 15;
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private List<ItemEntity> refreshItemEntityCache(HopperNBTMode hopperNBTMode, Level level, AABB searchArea) {
        return level.m_6443_(ItemEntity.class, searchArea, itemEntity -> {
            if (hopperNBTMode == HopperNBTMode.DENY) {
                return !itemEntity.m_32055_().m_41782_();
            }
            return true;
        });
    }

    private List<ExperienceOrb> refreshXpEntityCache(Level level, AABB searchArea) {
        return level.m_6443_(ExperienceOrb.class, searchArea, orb -> true);
    }

    private void fluidCollect(FilterMode filterMode, List<IStackType<?>> filterSlots, UnifiedStorage storage, Level level, AABB searchArea) {
        int minX = Mth.m_14107_((double)searchArea.f_82288_);
        int minY = Mth.m_14107_((double)searchArea.f_82289_);
        int minZ = Mth.m_14107_((double)searchArea.f_82290_);
        int maxX = Mth.m_14107_((double)searchArea.f_82291_);
        int maxY = Mth.m_14107_((double)searchArea.f_82292_);
        int maxZ = Mth.m_14107_((double)searchArea.f_82293_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    FluidStack extracted;
                    FluidStackType typedFluid;
                    pos.m_122178_(x, y, z);
                    FluidState fluidState = level.m_6425_((BlockPos)pos);
                    if (fluidState.m_76178_()) continue;
                    int amount = fluidState.m_76170_() ? 1000 : 0;
                    Fluid stillFluid = fluidState.m_76152_();
                    if (stillFluid instanceof FlowingFluid) {
                        FlowingFluid ff = (FlowingFluid)stillFluid;
                        stillFluid = ff.m_5613_();
                    }
                    if (!this.matchesFilter(filterMode, filterSlots, typedFluid = new FluidStackType(extracted = new FluidStack(stillFluid, 1)))) continue;
                    typedFluid.setStackAmount(amount);
                    if (!storage.insert(typedFluid, true).isEmpty()) continue;
                    storage.insert(typedFluid, false);
                    level.m_7731_((BlockPos)pos, Blocks.f_50016_.m_49966_(), 11);
                }
            }
        }
    }

    private boolean matchesFilter(FilterMode filterMode, List<IStackType<?>> filterSlots, IStackType<?> otherStack) {
        switch (filterMode) {
            case BLACK: {
                for (IStackType<?> stack : filterSlots) {
                    if (!stack.isSame(otherStack)) continue;
                    return false;
                }
                return true;
            }
            case WHITE: {
                for (IStackType<?> stack : filterSlots) {
                    if (!stack.isSame(otherStack)) continue;
                    return true;
                }
                return false;
            }
            case IGNORE: {
                return true;
            }
        }
        return false;
    }
}

