/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NetedItem
extends Item {
    public NetedItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.m_21120_(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || !player.m_6144_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!level.m_5776_()) {
            DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
            if (net != null) {
                NetedItem.setNet(itemstack, net, player);
            } else {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        super.m_7836_(stack, level, player);
        if (level.m_5776_()) {
            return;
        }
        DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
        if (net != null) {
            NetedItem.setNet(stack, net, player);
        }
    }

    public static DimensionsNet getNet(ItemStack stack, MinecraftServer dataProvider) {
        int netId = NetedItem.getNetId(stack);
        if (netId >= 0) {
            return DimensionsNet.getNetFromId(netId, dataProvider);
        }
        return null;
    }

    public static boolean setNet(ItemStack itemstack, DimensionsNet net, Player player) {
        Item item = itemstack.m_41720_();
        if (item instanceof NetedItem) {
            NetedItem item2 = (NetedItem)item;
            Level level = player.m_9236_();
            if (item2.validToReWrite(net, player)) {
                int netId = NetedItem.getNetId(itemstack);
                if (netId != net.getId()) {
                    NetedItem.setNetId(itemstack, net.getId());
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.8f, 1.0f);
                    player.m_213846_((Component)Component.m_237110_((String)"msg.beyonddimensions.item_net_bound", (Object[])new Object[]{net.getId()}));
                } else {
                    NetedItem.setNetId(itemstack, -1);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.8f, 1.0f);
                    player.m_213846_((Component)Component.m_237110_((String)"msg.beyonddimensions.item_net_unbound", (Object[])new Object[]{net.getId()}));
                }
                return true;
            }
            player.m_213846_((Component)Component.m_237115_((String)"msg.beyonddimensions.no_right_to_bound_item"));
            return false;
        }
        return false;
    }

    public static int getNetId(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("NetId")) {
            return stack.m_41783_().m_128451_("NetId");
        }
        return -1;
    }

    public static void setNetId(ItemStack stack, int netId) {
        stack.m_41784_().m_128405_("NetId", netId);
    }

    protected boolean validToReWrite(DimensionsNet net, Player player) {
        return net.isManager(player);
    }
}

