/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Machine.XpTransferSpeedMode;
import com.wintercogs.beyonddimensions.Tags.ModFluidTags;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.XpUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class XpExchangeItem
extends Item {
    public static List<Fluid> xpFluids = new ArrayList<Fluid>();

    public XpExchangeItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        this.checkComponents(stack);
        if (xpFluids.isEmpty()) {
            xpFluids = this.getExperienceFluids(level);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_() && XpExchangeItem.getOrDefaultXpNetKeepMode(stack, false)) {
                this.keepXpLevel(stack, player, level);
            }
        }
    }

    private void checkComponents(ItemStack stack) {
        if (!XpExchangeItem.hasXpTransferSpeedMode(stack)) {
            XpExchangeItem.setXpTransferSpeedMode(stack, XpTransferSpeedMode.SLOW);
        }
        if (!XpExchangeItem.hasXpNetKeepMode(stack)) {
            XpExchangeItem.setXpNetKeepMode(stack, false);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.beyonddimensions.item.xp_exchange"));
    }

    public static int getConversionRate() {
        return 20;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        super.m_7203_(level, player, usedHand);
        ItemStack itemstack = player.m_21120_(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (level.m_5776_() && player.m_6144_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!level.m_5776_()) {
            if (player.m_6144_()) {
                XpExchangeItem.cycleMode(itemstack, player, level);
            } else {
                boolean current = XpExchangeItem.getOrDefaultXpNetKeepMode(itemstack, false);
                XpExchangeItem.setXpNetKeepMode(itemstack, !current);
                if (XpExchangeItem.getOrDefaultXpNetKeepMode(itemstack, false)) {
                    player.m_213846_((Component)Component.m_237115_((String)"msg.beyonddimensions.item.xp_exchange.open"));
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"msg.beyonddimensions.item.xp_exchange.close"));
                }
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    private void keepXpLevel(ItemStack stack, Player player, Level level) {
        if (level.m_5776_()) {
            return;
        }
        DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
        if (net == null) {
            return;
        }
        int conversionRate = XpExchangeItem.getConversionRate();
        double currentLevel = XpUtil.levelAsDouble(player);
        int targetLevel = XpExchangeItem.getXpLevelPerAction(stack);
        UnifiedStorage storage = net.getUnifiedStorage();
        Fluid canonicalXp = (Fluid)ModFluids.XP_FLUID.source().get();
        if (currentLevel > (double)targetLevel) {
            long needRemoveXp = XpUtil.xpExcessAbove(currentLevel, targetLevel);
            int toRemoveXp = BDMath.clampLongToInt(needRemoveXp);
            long toInsertUnits = (long)toRemoveXp * (long)conversionRate;
            IStackType<?> remaining = storage.insert(new FluidStackType(new FluidStack(canonicalXp, 1), toInsertUnits), false);
            if (!remaining.isEmpty()) {
                int overflowXp = BDMath.clampLongToInt(remaining.getStackAmount() / (long)conversionRate);
                toRemoveXp -= overflowXp;
            }
            if (toRemoveXp != 0) {
                player.m_6756_(-toRemoveXp);
            }
        } else if (currentLevel < (double)targetLevel) {
            long needAddXp = XpUtil.xpToReachAtLeast(currentLevel, targetLevel);
            int remainingXp = BDMath.clampLongToInt(needAddXp);
            int gainedXpTotal = 0;
            for (Fluid f : xpFluids) {
                long wantUnits;
                if (remainingXp <= 0 || (wantUnits = (long)remainingXp * (long)conversionRate) <= 0L) break;
                IStackType<?> extracted = storage.extract(new FluidStackType(new FluidStack(f, 1), wantUnits), false);
                if (extracted.isEmpty()) continue;
                long units = extracted.getStackAmount();
                int gainedXp = BDMath.clampLongToInt(units / (long)conversionRate);
                if (gainedXp <= 0) {
                    storage.insert(new FluidStackType(new FluidStack(f, 1), units), false);
                    continue;
                }
                long consumedUnits = (long)gainedXp * (long)conversionRate;
                long remainderUnits = units - consumedUnits;
                if (remainderUnits > 0L) {
                    storage.insert(new FluidStackType(new FluidStack(f, 1), remainderUnits), false);
                }
                gainedXpTotal += gainedXp;
                remainingXp -= gainedXp;
            }
            if (gainedXpTotal > 0) {
                player.m_6756_(gainedXpTotal);
            }
        }
    }

    private List<Fluid> getExperienceFluids(Level level) {
        Registry reg = level.m_9598_().m_175515_(Registries.f_256808_);
        LinkedHashSet set = new LinkedHashSet();
        reg.m_203431_(ModFluidTags.C_EXPERIENCE).ifPresent(holders -> {
            for (Holder h : holders) {
                set.add((Fluid)h.m_203334_());
            }
        });
        return new ArrayList<Fluid>(set);
    }

    public static int getXpLevelPerAction(ItemStack stack) {
        if (stack.m_41720_() instanceof XpExchangeItem) {
            XpTransferSpeedMode xpMode = XpExchangeItem.getOrDefaultXpTransferSpeedMode(stack, XpTransferSpeedMode.SLOW);
            return switch (xpMode) {
                default -> throw new IncompatibleClassChangeError();
                case XpTransferSpeedMode.SLOW -> 1;
                case XpTransferSpeedMode.MID -> 10;
                case XpTransferSpeedMode.HIGH -> 30;
                case XpTransferSpeedMode.HIGHEST -> 100;
                case XpTransferSpeedMode.OVER_HIGHEST -> 150;
            };
        }
        return 0;
    }

    private static void cycleMode(ItemStack stack, Player player, Level level) {
        XpTransferSpeedMode cur = XpExchangeItem.getOrDefaultXpTransferSpeedMode(stack, XpTransferSpeedMode.SLOW);
        XpTransferSpeedMode next = cur.next();
        XpExchangeItem.setXpTransferSpeedMode(stack, next);
        player.m_213846_((Component)Component.m_237115_((String)("msg.beyonddimensions.xp_mode.switch." + next.name().toLowerCase(Locale.ENGLISH))));
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.8f, 1.0f);
    }

    public static XpTransferSpeedMode getOrDefaultXpTransferSpeedMode(ItemStack stack, XpTransferSpeedMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("xp_transfer_speed_mode")) {
            return XpTransferSpeedMode.valueOf(stack.m_41783_().m_128461_("xp_transfer_speed_mode"));
        }
        return defaultValue;
    }

    public static boolean hasXpTransferSpeedMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("xp_transfer_speed_mode");
    }

    public static void setXpTransferSpeedMode(ItemStack stack, XpTransferSpeedMode newMode) {
        stack.m_41784_().m_128359_("xp_transfer_speed_mode", newMode.name());
    }

    public static boolean getOrDefaultXpNetKeepMode(ItemStack stack, boolean defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("xp_net_keep_mode")) {
            return stack.m_41783_().m_128471_("xp_net_keep_mode");
        }
        return defaultValue;
    }

    public static boolean hasXpNetKeepMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("xp_net_keep_mode");
    }

    public static void setXpNetKeepMode(ItemStack stack, boolean newMode) {
        stack.m_41784_().m_128379_("xp_net_keep_mode", newMode);
    }
}

