/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Item.Custom.BaseMachineItem;
import com.wintercogs.beyonddimensions.Machine.FeederMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.FlagStackTypedSlot;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class NetFeederMenu
extends BDBaseMenu {
    private static final int slotStartY = 25;
    private static final int invSlotStartY = 111;
    private final IStackTypedHandler storage = new StackTypedHandler(36){

        @Override
        public void onChange() {
            super.onChange();
            if (!NetFeederMenu.this.player.m_9236_().m_5776_() && NetFeederMenu.this.initialized) {
                BaseMachineItem.setFilterSlots(NetFeederMenu.this.menuStack, new ArrayList(NetFeederMenu.this.storage.getStorage()));
            }
        }

        public boolean isStackValid(int slot, IStackType stack) {
            ItemStackType itemStackType;
            return super.isStackValid(slot, stack) && stack instanceof ItemStackType && (itemStackType = (ItemStackType)stack).getStack().getFoodProperties((LivingEntity)NetFeederMenu.this.player) != null;
        }
    };
    private boolean initialized;
    public final ItemStack menuStack;
    private RedStoneControlMode lastControlMode;
    private FeederMode lastFeederMode;

    public NetFeederMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, playerInventory.f_35978_.m_21120_((InteractionHand)data.m_130066_(InteractionHand.class)));
    }

    public NetFeederMenu(int containerId, Inventory playerInventory, ItemStack menuStack) {
        super(UIRegister.Net_Feeder_Menu.get(), containerId, playerInventory);
        this.menuStack = menuStack;
        this.initialized = false;
        if (!playerInventory.f_35978_.m_9236_().m_5776_()) {
            List<IStackType<?>> stacks = BaseMachineItem.getFilterSlotsOrDefault(menuStack, new ArrayList());
            for (int i = 0; i < stacks.size(); ++i) {
                this.storage.insert(i, stacks.get(i).copy(), false);
            }
        }
        this.initialized = true;
        this.addPlayerInv(playerInventory);
        this.addFlagSlots();
    }

    private void addFlagSlots() {
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                FlagStackTypedSlot flagSlot = new FlagStackTypedSlot(this, this.storage, row * 9 + col, 8 + col * 18, 25 + row * 18);
                this.m_38897_(flagSlot);
            }
        }
    }

    private void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 111 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 169));
        }
        this.inventoryEndIndex = this.f_38839_.size();
    }

    @Override
    public boolean m_6875_(Player player) {
        return this.menuStack != null && !this.menuStack.m_41619_();
    }

    @Override
    protected boolean shouldSendQuickData() {
        boolean result;
        boolean bl = result = super.shouldSendQuickData() || this.lastControlMode != BaseMachineItem.getControlModeOrDefault(this.menuStack, RedStoneControlMode.IGNORE) || this.lastFeederMode != BaseMachineItem.getFeederModeOrDefault(this.menuStack, FeederMode.NORMAL);
        if (result) {
            this.lastControlMode = BaseMachineItem.getControlModeOrDefault(this.menuStack, RedStoneControlMode.IGNORE);
            this.lastFeederMode = BaseMachineItem.getFeederModeOrDefault(this.menuStack, FeederMode.NORMAL);
        }
        return result;
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        tag.m_128359_("control_mode", BaseMachineItem.getControlModeOrDefault(this.menuStack, RedStoneControlMode.IGNORE).name());
        tag.m_128359_("feeder_mode", BaseMachineItem.getFeederModeOrDefault(this.menuStack, FeederMode.NORMAL).name());
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        BaseMachineItem.setControlMode(this.menuStack, RedStoneControlMode.valueOf(tag.m_128461_("control_mode")));
        BaseMachineItem.setFeederMode(this.menuStack, FeederMode.valueOf(tag.m_128461_("feeder_mode")));
    }
}

