/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toClient;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record OrderedStackTypedSlotPacket(int slotId, int slotIndex, IStackType stack, long newAmount) {
    @OnlyIn(value=Dist.CLIENT)
    private void handle(NetworkEvent.Context context) {
        Object object;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractContainerMenu menu = player.f_36096_;
        if (menu != null && (object = menu.f_38839_.get(this.slotId())) instanceof AbstractStackTypedSlot) {
            AbstractStackTypedSlot slot = (AbstractStackTypedSlot)((Object)object);
            slot.loadChange(this.slotIndex(), this.stack(), this.newAmount());
        }
    }

    public static void handle(OrderedStackTypedSlotPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handle(context)));
            context.setPacketHandled(true);
        }
    }

    public static void encode(OrderedStackTypedSlotPacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.slotId);
        buf.m_130130_(packet.slotIndex);
        packet.stack.serialize(buf);
        buf.m_130103_(packet.newAmount);
    }

    public static OrderedStackTypedSlotPacket decode(FriendlyByteBuf buf) {
        int slotId = buf.m_130242_();
        int slotIndex = buf.m_130242_();
        IStackType stack = IStackType.deserializeCommon(buf);
        long newAmount = buf.m_130258_();
        return new OrderedStackTypedSlotPacket(slotId, slotIndex, stack, newAmount);
    }
}

