/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toServer;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Api.Util.BytebufHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record PickBlockFromNetPacket(ItemStack targetStack) {
    private void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!player.m_21205_().m_41619_()) {
            return;
        }
        DimensionsNet net = DimensionsNet.getNetFromPlayer((Player)player);
        if (net == null) {
            return;
        }
        UnifiedStorage storage = net.getUnifiedStorage();
        ItemStackType target = null;
        for (IStackType<?> stack : storage.getStorage()) {
            ItemStackType itemStackType;
            if (!(stack instanceof ItemStackType) || (itemStackType = (ItemStackType)stack).getStack().m_41720_() != this.targetStack().m_41720_()) continue;
            target = (ItemStackType)itemStackType.copyWithCount(itemStackType.getVanillaMaxStackSize());
            break;
        }
        if (target != null && player.m_21205_().m_41619_()) {
            ItemStack extract = ((ItemStackType)storage.extract(target, false)).copyStack();
            player.m_21008_(InteractionHand.MAIN_HAND, extract);
        }
    }

    public static void handle(PickBlockFromNetPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> packet.handle(context));
            context.setPacketHandled(true);
        }
    }

    public static void encode(PickBlockFromNetPacket packet, FriendlyByteBuf buf) {
        BytebufHelper.writeItemBuf(buf, packet.targetStack);
    }

    public static PickBlockFromNetPacket decode(FriendlyByteBuf buf) {
        return new PickBlockFromNetPacket(BytebufHelper.readItemBuf(buf));
    }
}

