/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.EnergyType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.LongStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

public final class EnergyStackType
extends LongStackType<EnergyType> {
    public static final ResourceLocation ID = new ResourceLocation("beyonddimensions", "stack_type/energy");
    public static final EnergyStackType EMPTY = new EnergyStackType();

    public EnergyStackType() {
        this.stack = new EnergyType(0L);
    }

    public EnergyStackType(EnergyType stack) {
        this.stack = stack;
    }

    public EnergyStackType(long stackSize) {
        this.stack = new EnergyType(stackSize);
    }

    @Override
    public ResourceLocation getTypeID() {
        return ID;
    }

    @Override
    public IStackType<EnergyType> fromObject(Object key, long amount, CompoundTag dataComponentPatch) {
        if (key instanceof EnergyType) {
            return new EnergyStackType(amount);
        }
        return null;
    }

    @Override
    public IStackType<EnergyType> getEmpty() {
        return new EnergyStackType();
    }

    @Override
    public Object getSource() {
        return new EnergyType(0L);
    }

    @Override
    public EnergyType getEmptyStack() {
        return new EnergyType(0L);
    }

    @Override
    public IStackType<EnergyType> copy() {
        EnergyStackType copy = new EnergyStackType(((EnergyType)this.stack).getStackCount());
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<EnergyType> copyWithCount(long count) {
        EnergyStackType copy = new EnergyStackType(count);
        if (count == ((EnergyType)this.stack).getStackCount()) {
            copy.NeedRecalHash = this.NeedRecalHash;
            copy.hashCodeCache = this.hashCodeCache;
        }
        return copy;
    }

    @Override
    public IStackType<EnergyType> split(long amount) {
        if (amount <= 0L) {
            return new EnergyStackType();
        }
        long splitAmount = Math.min(amount, ((EnergyType)this.stack).getStackCount());
        ((EnergyType)this.stack).shrink(splitAmount);
        return new EnergyStackType(splitAmount);
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130085_(this.getTypeId());
        buf.m_130103_(((EnergyType)this.stack).getStackCount());
    }

    @Override
    public IStackType<EnergyType> deserialize(FriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        long count = buf.m_130258_();
        return new EnergyStackType(count);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", ID.toString());
        tag.m_128356_("Amount", this.getStackAmount());
        return tag;
    }

    @Override
    public IStackType<EnergyType> deserializeNBT(CompoundTag nbt) {
        return new EnergyStackType(nbt.m_128454_("Amount"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        IClientFluidTypeExtensions renderProperties;
        ResourceLocation fluidStill;
        Optional<TextureAtlasSprite> fluidStillSprite;
        if (((EnergyType)this.stack).isEmpty()) {
            return;
        }
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        FlowingFluid fluid = Fluids.f_76193_;
        if (!fluid.m_6212_(Fluids.f_76191_) && (fluidStillSprite = Optional.ofNullable(fluidStill = (renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid)).getStillTexture()).map(f -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(f)).filter(s -> s.m_247685_() != MissingTextureAtlasSprite.m_118071_())).isPresent()) {
            int fluidColor = 5304718;
            IngredientRenderer.drawTiledSprite(gui, 16, 16, fluidColor, 16L, fluidStillSprite.get(), x, y);
        }
        poseStack.m_85849_();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.m_280168_();
        poseStackText.m_85836_();
        poseStackText.m_252880_(0.0f, 0.0f, 200.0f);
        poseStackText.m_85841_(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92895_(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!((EnergyType)this.stack).isEmpty()) {
            gui.m_280488_(Minecraft.m_91087_().f_91062_, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.m_85849_();
    }
}

