/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Menu.NetPumpMenu;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class NetPumpBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    private final Multimap<ResourceLocation, Object> handlerCache = ArrayListMultimap.create();
    private boolean needsCapabilityUpdate = true;
    private final Direction[] directions = Direction.values();
    private static final int capacity = 36;
    private final StackTypedHandler filterSlots = new StackTypedHandler(36){

        @Override
        public void onChange() {
            if (!NetPumpBlockEntity.this.f_58857_.m_5776_()) {
                NetPumpBlockEntity.this.f_58857_.m_151543_(NetPumpBlockEntity.this.f_58858_);
            }
        }
    };
    public FilterMode filterMode = FilterMode.BLACK;

    public NetPumpBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_PUMP_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public boolean shouldWork() {
        return super.shouldWork() && this.getNet() != null;
    }

    @Override
    public int getTicksPerWork() {
        return 10;
    }

    @Override
    public void workStart() {
        if (this.f_58857_ == null || !this.needsCapabilityUpdate) {
            return;
        }
        this.handlerCache.clear();
        for (Direction dir : this.directions) {
            BlockPos targetPos = this.m_58899_().m_121945_(dir);
            BlockEntity neighbor = this.f_58857_.m_7702_(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity) continue;
            CapabilityHelper.BlockCapabilityMap.forEach((resourceLocation, cap) -> {
                LazyOptional handler = neighbor.getCapability(cap, dir.m_122424_());
                if (handler.isPresent()) {
                    this.handlerCache.put(resourceLocation, handler.resolve().get());
                }
            });
        }
        this.needsCapabilityUpdate = false;
    }

    @Override
    public void workContent() {
        this.handlerCache.forEach((typeId, handler) -> {
            Function<?, IStackHandlerWrapper<?>> handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId);
            IStackHandlerWrapper<?> stackHandlerWrapper = handlerGetter.apply(handler);
            for (int slot = 0; slot < stackHandlerWrapper.getSlots(); ++slot) {
                DimensionsNet net;
                Object stack = stackHandlerWrapper.getStackInSlot(slot);
                IStackType<?> typedStack = StackCreater.CreateEmpty(typeId);
                typedStack.setStack(stack);
                if (typedStack.isEmpty() || !this.matchesFilter(typedStack) || (net = this.getNet()) == null) continue;
                UnifiedStorage storage = net.getUnifiedStorage();
                long canInsert = typedStack.getStackAmount() - storage.insert(typedStack, true).getStackAmount();
                canInsert = Math.min(canInsert, typedStack.getStackAmount());
                long extract = stackHandlerWrapper.extract(slot, canInsert, false);
                typedStack.setStackAmount(extract);
                net.getUnifiedStorage().insert(typedStack, false);
            }
        });
    }

    private boolean matchesFilter(IStackType otherStack) {
        switch (this.filterMode) {
            case BLACK: {
                for (IStackType stack : this.filterSlots.getStorage()) {
                    if (!stack.isSame(otherStack)) continue;
                    return false;
                }
                return true;
            }
            case WHITE: {
                for (IStackType stack : this.filterSlots.getStorage()) {
                    if (!stack.isSame(otherStack)) continue;
                    return true;
                }
                return false;
            }
            case IGNORE: {
                return true;
            }
        }
        return false;
    }

    public void setNeedsCapabilityUpdate() {
        this.needsCapabilityUpdate = true;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.setNeedsCapabilityUpdate();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.filterSlots.deserializeNBT(tag.m_128469_("filter_slots"));
        this.filterMode = FilterMode.valueOf(tag.m_128461_("filter_type"));
        this.setNeedsCapabilityUpdate();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("filter_slots", (Tag)this.filterSlots.serializeNBT());
        tag.m_128359_("filter_type", this.filterMode.name());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"menu.title.beyonddimensions.pump_menu");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new NetPumpMenu(containerId, inventory, this.filterSlots, this);
    }
}

