/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.FluidHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class DisorderedStackTypedSlot
extends AbstractStackTypedSlot {
    public DisorderedStackTypedSlot(BDBaseMenu menu, IStackTypedHandler stackTypedHandler, int slotIndex, int xPosition, int yPosition) {
        super(menu, stackTypedHandler, slotIndex, xPosition, yPosition);
    }

    public DisorderedStackTypedSlot(BDBaseMenu menu, IStackTypedHandler stackTypedHandler, int slotIndex, int quickMoveSlotStartIndex, int quickMoveSlotEndIndex, int xPosition, int yPosition) {
        super(menu, stackTypedHandler, slotIndex, quickMoveSlotStartIndex, quickMoveSlotEndIndex, xPosition, yPosition);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public void click(IStackType clickStack, int button, Player player) {
        ItemStack carriedItem = this.menu.m_142621_().m_41777_();
        if (clickStack.isEmpty()) {
            if (!carriedItem.m_41619_()) {
                AtomicBoolean handled = new AtomicBoolean(false);
                if (carriedItem.m_41613_() == 1 && button == 1) {
                    Item item = carriedItem.m_41720_();
                    if (item instanceof BucketItem) {
                        int changedCount;
                        int remaining;
                        FluidStackType stack;
                        FluidHandlerWrapper stackHandlerWrapper;
                        BucketItem bucketItem = (BucketItem)item;
                        LazyOptional handler = carriedItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
                        if (handler.isPresent() && (stackHandlerWrapper = new FluidHandlerWrapper(handler.resolve().get())).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty() && (remaining = (int)this.storage.insert(stack.copyWithCount(changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()))), true).getStackAmount()) <= 0) {
                            this.storage.insert(stack.copyWithCount(changedCount), false).getStackAmount();
                            this.menu.m_142503_(new ItemStack((ItemLike)Items.f_42446_));
                            handled.set(true);
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            LazyOptional handler = carriedItem.getCapability(cap);
                            if (handler.isPresent() && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler.resolve().get())).getSlots() > 0) {
                                for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                    int remaining;
                                    int changedCount;
                                    int actualInsert;
                                    IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(index));
                                    if (stack == null || stack.isEmpty() || (actualInsert = (changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()))) - (remaining = (int)this.storage.insert(stack.copyWithCount(changedCount), false).getStackAmount())) <= 0) continue;
                                    long actualExtracts = stackHandlerWrapper.extract(index, actualInsert, false);
                                    if (actualExtracts < (long)actualInsert) {
                                        this.storage.extract(stack.copyWithCount((long)actualInsert - actualExtracts), false);
                                    }
                                    this.menu.m_142503_(carriedItem.m_41777_());
                                    handled.set(true);
                                    break;
                                }
                            }
                        });
                    }
                }
                if (!handled.get()) {
                    int changedCount = button == 0 ? carriedItem.m_41613_() : 1;
                    int actualInsert = (int)((long)changedCount - this.storage.insert(StackCreater.Create(ItemStackType.ID, carriedItem.m_255036_(changedCount), changedCount), false).getStackAmount());
                    int newCount = carriedItem.m_41613_() - actualInsert;
                    if (newCount <= 0) {
                        this.menu.m_142503_(ItemStack.f_41583_);
                    } else {
                        ItemStack newCarriedItem = carriedItem.m_41777_();
                        newCarriedItem.m_41764_(newCount);
                        this.menu.m_142503_(newCarriedItem);
                    }
                }
            }
        } else if (this.m_8010_(player)) {
            if (carriedItem.m_41619_()) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickItem = (ItemStackType)clickStack;
                    int woundChangeNum = BDMath.clampLongToInt(Math.min(clickItem.getStackAmount(), clickItem.getVanillaMaxStackSize()));
                    int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
                    ItemStack takenItem = ((ItemStack)this.storage.extract(new ItemStackType(clickItem.copyStackWithCount(actualChangeNum)), false).getStack()).m_41777_();
                    if (takenItem != null) {
                        this.menu.m_142503_(takenItem);
                        this.storage.onChange();
                    }
                }
            } else if (this.m_5857_(carriedItem)) {
                AtomicBoolean handled = new AtomicBoolean(false);
                if (carriedItem.m_41613_() == 1 && button == 1) {
                    Item actualChangeNum = carriedItem.m_41720_();
                    if (actualChangeNum instanceof BucketItem) {
                        BucketItem bucket = (BucketItem)actualChangeNum;
                        if (bucket == Items.f_42446_) {
                            FluidStackType fluidStackType;
                            Item filledBucket;
                            if (clickStack instanceof FluidStackType && (filledBucket = (fluidStackType = (FluidStackType)clickStack).getStack().getFluid().m_6859_()) != null && filledBucket != Items.f_41852_ && this.storage.getStackByStack(fluidStackType).getStackAmount() >= 1000L) {
                                this.storage.extract(fluidStackType.copyWithCount(1000L), false);
                                this.menu.m_142503_(new ItemStack((ItemLike)filledBucket));
                                handled.set(true);
                            }
                        } else {
                            int changedCount;
                            int remaining;
                            FluidStackType stack;
                            FluidHandlerWrapper stackHandlerWrapper;
                            LazyOptional handler = carriedItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
                            if (handler.isPresent() && (stackHandlerWrapper = new FluidHandlerWrapper(handler.resolve().get())).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty() && (remaining = (int)this.storage.insert(stack.copyWithCount(changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()))), true).getStackAmount()) <= 0) {
                                this.storage.insert(stack.copyWithCount(changedCount), false).getStackAmount();
                                this.menu.m_142503_(new ItemStack((ItemLike)Items.f_42446_));
                                handled.set(true);
                            }
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            int remaining;
                            int changedCount;
                            int actualInsert;
                            IStackType actualClickStack;
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            LazyOptional handler;
                            if (clickStack.getTypeId().equals(typeId) && (handler = carriedItem.getCapability(cap)).isPresent() && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler.resolve().get())).getSlots() > 0 && (actualClickStack = this.storage.getStackByStack(clickStack)) != null && (actualInsert = (changedCount = BDMath.clampLongToInt(Math.min(actualClickStack.getStackAmount(), actualClickStack.getVanillaMaxStackSize()))) - (remaining = (int)stackHandlerWrapper.insert(actualClickStack.copyStackWithCount(changedCount), false))) > 0) {
                                this.storage.extract(actualClickStack.copyWithCount(actualInsert), false);
                                this.menu.m_142503_(carriedItem.m_41777_());
                                handled.set(true);
                            }
                        });
                        if (!handled.get()) {
                            CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                                Function<?, IStackHandlerWrapper<?>> handlerGetter;
                                IStackHandlerWrapper<?> stackHandlerWrapper;
                                LazyOptional handler = carriedItem.getCapability(cap);
                                if (handler.isPresent() && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler.resolve().get())).getSlots() > 0) {
                                    for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                        int remaining;
                                        int changedCount;
                                        int actualInsert;
                                        IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(index));
                                        if (stack == null || stack.isEmpty() || (actualInsert = (changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()))) - (remaining = (int)this.storage.insert(stack.copyWithCount(changedCount), false).getStackAmount())) <= 0) continue;
                                        long actualExtracts = stackHandlerWrapper.extract(index, actualInsert, false);
                                        if (actualExtracts < (long)actualInsert) {
                                            this.storage.extract(stack.copyWithCount((long)actualInsert - actualExtracts), false);
                                        }
                                        this.menu.m_142503_(carriedItem.m_41777_());
                                        handled.set(true);
                                        break;
                                    }
                                }
                            });
                        }
                    }
                }
                if (!handled.get()) {
                    int changedCount = button == 0 ? carriedItem.m_41613_() : 1;
                    this.storage.insert(StackCreater.Create(ItemStackType.ID, carriedItem.m_255036_(changedCount), changedCount), false);
                    int newCount = carriedItem.m_41613_() - changedCount;
                    if (newCount <= 0) {
                        this.menu.m_142503_(ItemStack.f_41583_);
                    } else {
                        ItemStack newCarriedItem = carriedItem.m_41777_();
                        newCarriedItem.m_41764_(newCount);
                        this.menu.m_142503_(newCarriedItem);
                    }
                }
            } else if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.m_41777_()))) {
                // empty if block
            }
        }
    }

    @Override
    public void quickMove(IStackType clickStack, int button, Player player) {
        if (!clickStack.isEmpty()) {
            ItemStackType trueStack = this.storage.getStackByStack(clickStack).copyWithCount(clickStack.getStackAmount());
            for (int targetSlotIndex = this.quickMoveSlotStartIndex; targetSlotIndex < this.quickMoveSlotEndIndex && !trueStack.isEmpty(); ++targetSlotIndex) {
                Slot slot = (Slot)this.menu.f_38839_.get(targetSlotIndex);
                if (slot instanceof AbstractStackTypedSlot) {
                    AbstractStackTypedSlot aSlot = (AbstractStackTypedSlot)slot;
                    IStackType extract = this.storage.extract(trueStack, false);
                    IStackType remaining = aSlot.safeInsert(extract);
                    if (!remaining.isEmpty()) {
                        this.storage.insert(remaining, false);
                    }
                    trueStack = remaining.copy();
                    continue;
                }
                if (!(trueStack instanceof ItemStackType)) continue;
                ItemStackType trueItemTypedStack = trueStack;
                ItemStack extract = (ItemStack)this.storage.extract(trueItemTypedStack, false).getStack();
                ItemStack remaining = slot.m_150659_(extract);
                if (!remaining.m_41619_()) {
                    this.storage.insert(new ItemStackType(remaining), false);
                }
                trueStack = new ItemStackType(remaining.m_41777_());
            }
            this.m_6654_();
        }
    }

    @Override
    public IStackType safeInsert(IStackType stack) {
        if (stack != null) {
            return this.storage.insert(stack, false);
        }
        return new ItemStackType();
    }

    @Override
    public IStackType safeExtract(IStackType stack) {
        if (stack != null) {
            return this.storage.extract(stack, false);
        }
        return new ItemStackType();
    }

    @Override
    public void updateChange() {
    }

    @Override
    public void loadChange(int where, IStackType newStack, long newAmount) {
    }
}

