/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.ClientOrServer;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record SetSlotDirectlyPacket(int slotId, IStackType stack) {
    private void handleServer(NetworkEvent.Context context) {
        Object object;
        ServerPlayer player = context.getSender();
        AbstractContainerMenu menu = player.f_36096_;
        if (menu != null && (object = menu.f_38839_.get(this.slotId())) instanceof AbstractStackTypedSlot) {
            AbstractStackTypedSlot slot = (AbstractStackTypedSlot)((Object)object);
            slot.setStackDirectly(this.stack());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient(NetworkEvent.Context context) {
        Object object;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractContainerMenu menu = player.f_36096_;
        if (menu != null && (object = menu.f_38839_.get(this.slotId())) instanceof AbstractStackTypedSlot) {
            AbstractStackTypedSlot slot = (AbstractStackTypedSlot)((Object)object);
            slot.setStackDirectly(this.stack());
        }
    }

    public static void handle(SetSlotDirectlyPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            NetworkDirection direction = context.getDirection();
            if (direction == NetworkDirection.PLAY_TO_CLIENT) {
                context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handleClient(context)));
                context.setPacketHandled(true);
            } else if (direction == NetworkDirection.PLAY_TO_SERVER) {
                context.enqueueWork(() -> packet.handleServer(context));
                context.setPacketHandled(true);
            }
        }
    }

    public static void encode(SetSlotDirectlyPacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.slotId);
        packet.stack.serialize(buf);
    }

    public static SetSlotDirectlyPacket decode(FriendlyByteBuf buf) {
        int slotId = buf.m_130242_();
        IStackType stack = IStackType.deserializeCommon(buf);
        return new SetSlotDirectlyPacket(slotId, stack);
    }
}

