/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Unit;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;

public class TooltipHelper {
    private static final AtomicLong EPOCH = new AtomicLong(0L);
    private static final Map<IStackType, List<Component>> NORMAL_CACHE = new ConcurrentHashMap<IStackType, List<Component>>();
    private static final Map<IStackType, List<Component>> ADVANCED_CACHE = new ConcurrentHashMap<IStackType, List<Component>>();
    private static final Map<IStackType, CompletableFuture<List<Component>>> NORMAL_PENDING = new ConcurrentHashMap<IStackType, CompletableFuture<List<Component>>>();
    private static final Map<IStackType, CompletableFuture<List<Component>>> ADVANCED_PENDING = new ConcurrentHashMap<IStackType, CompletableFuture<List<Component>>>();
    private static final ExecutorService TOOLTIP_EXECUTOR = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2), r -> {
        Thread t = new Thread(r, "Tooltip-Loader");
        t.setDaemon(true);
        return t;
    });

    private static CompletableFuture<List<Component>> loadAsync(IStackType stack, @Nullable Player player, TooltipFlag flag, Map<IStackType, List<Component>> cache, Map<IStackType, CompletableFuture<List<Component>>> pending) {
        long taskEpoch = EPOCH.get();
        return pending.computeIfAbsent(stack, s -> CompletableFuture.supplyAsync(() -> stack.getTooltipLines(player, flag), TOOLTIP_EXECUTOR).whenComplete((tooltip, err) -> {
            pending.remove(stack);
            if (err != null) {
                ((Throwable)err).printStackTrace();
                return;
            }
            if (taskEpoch == EPOCH.get()) {
                cache.put(stack, (List)tooltip);
            }
        }));
    }

    public static List<Component> getTooltipLines(IStackType stack, @Nullable Player player, TooltipFlag flag) {
        boolean advanced = flag.m_7050_();
        Map<IStackType, List<Component>> cache = advanced ? ADVANCED_CACHE : NORMAL_CACHE;
        Map<IStackType, CompletableFuture<List<Component>>> pending = advanced ? ADVANCED_PENDING : NORMAL_PENDING;
        List<Component> cached = cache.get(stack);
        if (cached != null) {
            return cached;
        }
        try {
            return TooltipHelper.loadAsync(stack, player, flag, cache, pending).get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        catch (ExecutionException ee) {
            ee.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static void readAsCache(List<IStackType> stacks, @Nullable Player player, TooltipFlag flag) {
        boolean advanced = flag.m_7050_();
        Map<IStackType, List<Component>> cache = advanced ? ADVANCED_CACHE : NORMAL_CACHE;
        Map<IStackType, CompletableFuture<List<Component>>> pending = advanced ? ADVANCED_PENDING : NORMAL_PENDING;
        for (IStackType stack : stacks) {
            if (cache.containsKey(stack)) continue;
            TooltipHelper.loadAsync(stack, player, flag, cache, pending);
        }
    }

    public static void clearCache() {
        EPOCH.incrementAndGet();
        NORMAL_CACHE.clear();
        ADVANCED_CACHE.clear();
        NORMAL_PENDING.clear();
        ADVANCED_PENDING.clear();
    }
}

