/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackType
implements IStackType<ItemStack> {
    public static final ResourceLocation ID;
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private ItemStack stack;
    private long stackSize;
    private int hashCodeCache = 0;
    private boolean NeedRecalHash = true;
    private static final MethodHandle SERIALIZE_CAPS_HANDLE;
    private static final MethodHandle DESERIALIZE_CAPS_HANDLE;

    @Nullable
    private static CompoundTag serializeStackCaps(ItemStack stack) {
        try {
            CompoundTag caps = SERIALIZE_CAPS_HANDLE.invokeExact((CapabilityProvider)stack);
            return caps == null || caps.m_128456_() ? null : caps;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to call serializeCaps", ex);
        }
    }

    @Nullable
    private static void deserializeStackCaps(ItemStack stack, CompoundTag caps) {
        try {
            if (caps != null && !caps.m_128456_()) {
                DESERIALIZE_CAPS_HANDLE.invokeExact((CapabilityProvider)stack, caps);
            }
            return;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to call serializeCaps", ex);
        }
    }

    public ItemStackType() {
        this.stack = ItemStack.f_41583_;
        this.stackSize = 0L;
    }

    public ItemStackType(ItemStack stack) {
        this.stack = stack;
        this.stackSize = stack.m_41613_();
    }

    public ItemStackType(ItemStack stack, long stackSize) {
        this.stack = stack;
        this.stackSize = stackSize;
    }

    @Override
    public IStackType<ItemStack> fromObject(Object key, long amount, CompoundTag dataComponentPatch) {
        if (key instanceof Item) {
            Item item = (Item)key;
            ItemStack itemStack = dataComponentPatch != null ? new ItemStack((ItemLike)item, 1, dataComponentPatch) : new ItemStack((ItemLike)item, 1);
            return new ItemStackType(itemStack, amount);
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        this.stack.m_41764_(BDMath.clampLongToInt(this.stackSize));
        return this.stack;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.stack = stack.m_41777_();
        this.stackSize = stack.m_41613_();
        this.NeedRecalHash = true;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<ItemStack> getEmpty() {
        return new ItemStackType();
    }

    @Override
    public Class<ItemStack> getStackClass() {
        return ItemStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Item.class;
    }

    @Override
    public Object getSource() {
        return ItemStack.f_41583_.m_41720_();
    }

    @Override
    public String getModId() {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_());
        return key != null ? key.m_135827_() : "unknown";
    }

    @Override
    public boolean isEmpty() {
        return this.stack.m_41619_() || this.stackSize <= 0L;
    }

    @Override
    public boolean isEmptyStack() {
        return this.stack.m_41619_();
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack copyStack() {
        return this.stack.m_255036_(BDMath.clampLongToInt(this.stackSize));
    }

    @Override
    public ItemStack copyStackWithCount(long count) {
        return this.stack.m_255036_(BDMath.clampLongToInt(count));
    }

    @Override
    public IStackType<ItemStack> copy() {
        ItemStackType copy = new ItemStackType(this.stack.m_41777_(), this.stackSize);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<ItemStack> copyWithCount(long count) {
        ItemStackType copy = new ItemStackType(this.stack.m_41777_(), count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public long getStackAmount() {
        return this.stackSize;
    }

    @Override
    public void setStackAmount(long amount) {
        this.stackSize = amount;
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Math.min((long)this.stack.m_41741_(), this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public ItemStack splitStack(long amount) {
        if (amount <= 0L) {
            return ItemStack.f_41583_;
        }
        int splitAmount = BDMath.clampLongToInt(Math.min(amount, this.stackSize));
        ItemStack split = this.stack.m_41777_();
        split.m_41764_(splitAmount);
        this.shrink(splitAmount);
        return split;
    }

    @Override
    public IStackType<ItemStack> split(long amount) {
        if (amount <= 0L) {
            return new ItemStackType();
        }
        long splitAmount = Math.min(amount, this.stackSize);
        ItemStack split = this.stack.m_41777_();
        this.shrink(splitAmount);
        return new ItemStackType(split, splitAmount);
    }

    @Override
    public boolean isSame(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ItemStack.m_41656_((ItemStack)this.stack, (ItemStack)other.copyStackWithCount(1L));
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        ItemStack copyOther = other.copyStackWithCount(1L);
        boolean result = !this.stack.m_150930_(copyOther.m_41720_()) ? false : (this.stack.m_41619_() && copyOther.m_41619_() ? true : Objects.equals(this.stack.m_41783_(), copyOther.m_41783_()) && Objects.equals(ItemStackType.serializeStackCaps(this.stack), ItemStackType.serializeStackCaps(copyOther)));
        return result;
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130085_(this.getTypeId());
        boolean hasItem = !this.stack.m_41619_();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.m_130103_(this.stackSize);
            ItemStack copy = this.stack.m_255036_(1);
            buf.m_130055_(copy);
            buf.m_130079_(ItemStackType.serializeStackCaps(copy));
        }
    }

    public ItemStackType deserialize(FriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ItemStackType(ItemStack.f_41583_);
        }
        long count = buf.m_130258_();
        ItemStack stack = buf.m_130267_();
        CompoundTag capNBTTag = buf.m_130260_();
        ItemStackType.deserializeStackCaps(stack, capNBTTag);
        return new ItemStackType(stack, count);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", ID.toString());
        tag.m_128356_("Amount", this.getStackAmount());
        tag.m_128365_("Stack", (Tag)this.stack.m_255036_(1).m_41739_(new CompoundTag()));
        return tag;
    }

    public ItemStackType deserializeNBT(CompoundTag nbt) {
        ItemStackType stack = new ItemStackType(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Stack")));
        stack.setStackAmount(nbt.m_128454_("Amount"));
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        this.stack.m_41764_(1);
        gui.m_280203_(this.stack, x, y);
        gui.m_280302_(Minecraft.m_91087_().f_91062_, this.stack, x, y, "");
        poseStack.m_85849_();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.m_280168_();
        poseStackText.m_85836_();
        poseStackText.m_252880_(0.0f, 0.0f, 200.0f);
        poseStackText.m_85841_(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92895_(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!this.stack.m_41619_()) {
            gui.m_280488_(Minecraft.m_91087_().f_91062_, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.m_85849_();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName() {
        return this.stack.m_41611_();
    }

    @Override
    public List<Component> getTooltipLines(@Nullable Player player, TooltipFlag tooltipFlag) {
        List tooltips = this.stack.m_41651_(player, tooltipFlag);
        tooltips.add(Component.m_237110_((String)"istack.beyonddimensions.storage_num.item", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return this.stack.m_150921_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        gui.renderTooltip(minecraft.f_91062_, this.getTooltipLines((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)), this.getTooltipImage(), ItemStack.f_41583_, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof ItemStackType) {
            ItemStackType otherStack = (ItemStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.NeedRecalHash) {
            if (this.stack != null) {
                int i = 31 + this.stack.m_41720_().hashCode();
                this.hashCodeCache = this.stack.m_41782_() ? i * 31 + this.stack.m_41783_().hashCode() : i;
            } else {
                this.hashCodeCache = 0;
            }
            this.NeedRecalHash = false;
        }
        return this.hashCodeCache;
    }

    static {
        Method method;
        ID = ResourceLocation.m_214293_((String)"beyonddimensions", (String)"stack_type/item");
        try {
            method = CapabilityProvider.class.getDeclaredMethod("serializeCaps", new Class[0]);
            method.setAccessible(true);
            SERIALIZE_CAPS_HANDLE = MethodHandles.lookup().unreflect(method);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create serializeCaps method handle", exception);
        }
        try {
            method = CapabilityProvider.class.getDeclaredMethod("deserializeCaps", CompoundTag.class);
            method.setAccessible(true);
            DESERIALIZE_CAPS_HANDLE = MethodHandles.lookup().unreflect(method);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create deserializeCaps method handle", exception);
        }
    }
}

