/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Machine.XpTransferSpeedMode;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.XpUtil;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class XpExchangeItem
extends Item {
    public XpExchangeItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        this.checkComponents(stack);
    }

    private void checkComponents(ItemStack stack) {
        if (!XpExchangeItem.hasXpTransferSpeedMode(stack)) {
            XpExchangeItem.setXpTransferSpeedMode(stack, XpTransferSpeedMode.SLOW);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.beyonddimensions.item.xp_exchange"));
    }

    public static int getConversionRate() {
        return 20;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        super.m_7203_(level, player, usedHand);
        ItemStack itemstack = player.m_21120_(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (level.m_5776_() && player.m_6144_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!level.m_5776_()) {
            if (player.m_6144_()) {
                XpExchangeItem.cycleMode(itemstack, player, level);
            } else {
                DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
                if (net != null) {
                    int conversionRate = XpExchangeItem.getConversionRate();
                    double currentLevel = XpUtil.levelAsDouble(player);
                    int wantConversionLevel = XpExchangeItem.getXpLevelPerAction(itemstack);
                    UnifiedStorage storage = net.getUnifiedStorage();
                    long needRemovePlayerXp = XpUtil.xpBetweenLevels(Math.max(currentLevel - (double)wantConversionLevel, 0.0), currentLevel);
                    int actualRemovePlayerXp = BDMath.clampLongToInt(needRemovePlayerXp);
                    long actualInsertFluid = (long)actualRemovePlayerXp * (long)conversionRate;
                    IStackType remaining = storage.insert(new FluidStackType(new FluidStack((Fluid)ModFluids.XP_FLUID.source().get(), 1), actualInsertFluid), false);
                    if (!remaining.isEmpty()) {
                        int needReturnXp = BDMath.clampLongToInt(remaining.getStackAmount() / 20L);
                        actualRemovePlayerXp -= needReturnXp;
                    }
                    player.m_6756_(-actualRemovePlayerXp);
                }
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public static int getXpLevelPerAction(ItemStack stack) {
        if (stack.m_41720_() instanceof XpExchangeItem) {
            XpTransferSpeedMode xpMode = XpExchangeItem.getOrDefaultXpTransferSpeedMode(stack, XpTransferSpeedMode.SLOW);
            return switch (xpMode) {
                default -> throw new IncompatibleClassChangeError();
                case XpTransferSpeedMode.SLOW -> 1;
                case XpTransferSpeedMode.MID -> 10;
                case XpTransferSpeedMode.HIGH -> 30;
                case XpTransferSpeedMode.HIGHEST -> 100;
            };
        }
        return 0;
    }

    private static void cycleMode(ItemStack stack, Player player, Level level) {
        XpTransferSpeedMode cur = XpExchangeItem.getOrDefaultXpTransferSpeedMode(stack, XpTransferSpeedMode.SLOW);
        XpTransferSpeedMode next = cur.next();
        XpExchangeItem.setXpTransferSpeedMode(stack, next);
        player.m_213846_((Component)Component.m_237115_((String)("msg.beyonddimensions.xp_mode.switch." + next.name().toLowerCase(Locale.ENGLISH))));
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.8f, 1.0f);
    }

    public static XpTransferSpeedMode getOrDefaultXpTransferSpeedMode(ItemStack stack, XpTransferSpeedMode defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("xp_transfer_speed_mode")) {
            return XpTransferSpeedMode.valueOf(stack.m_41783_().m_128461_("xp_transfer_speed_mode"));
        }
        return defaultValue;
    }

    public static boolean hasXpTransferSpeedMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("xp_transfer_speed_mode");
    }

    public static void setXpTransferSpeedMode(ItemStack stack, XpTransferSpeedMode newMode) {
        stack.m_41784_().m_128359_("xp_transfer_speed_mode", newMode.name());
    }
}

